/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.paypal.api.payments.CreateProfileResponse;
import com.paypal.api.payments.FlowConfig;
import com.paypal.api.payments.InputFields;
import com.paypal.api.payments.PatchRequest;
import com.paypal.api.payments.Presentation;
import com.paypal.api.payments.WebProfileList;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class WebProfile
extends PayPalResource {
    private String id;
    private String name;
    private Boolean temporary;
    private FlowConfig flowConfig;
    private InputFields inputFields;
    private Presentation presentation;

    public WebProfile() {
    }

    public WebProfile(String name) {
        this.name = name;
    }

    public CreateProfileResponse create(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return this.create(apiContext);
    }

    public CreateProfileResponse create(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/payment-experience/web-profiles";
        String payLoad = this.toJSON();
        return WebProfile.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, CreateProfileResponse.class);
    }

    public void update(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.update(apiContext);
    }

    public void update(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        WebProfile.configureAndExecute(apiContext, HttpMethod.PUT, resourcePath, payLoad, null);
    }

    public void partialUpdate(String accessToken, PatchRequest patchRequest) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.partialUpdate(apiContext, patchRequest);
    }

    public void partialUpdate(APIContext apiContext, PatchRequest patchRequest) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        if (patchRequest == null) {
            throw new IllegalArgumentException("patchRequest cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = patchRequest.toJSON();
        WebProfile.configureAndExecute(apiContext, HttpMethod.PATCH, resourcePath, payLoad, null);
    }

    public static WebProfile get(String accessToken, String profileId) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return WebProfile.get(apiContext, profileId);
    }

    public static WebProfile get(APIContext apiContext, String profileId) throws PayPalRESTException {
        if (profileId == null) {
            throw new IllegalArgumentException("profileId cannot be null");
        }
        Object[] parameters = new Object[]{profileId};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return WebProfile.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, WebProfile.class);
    }

    public static List<WebProfile> getList(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        return WebProfile.getList(apiContext);
    }

    public static List<WebProfile> getList(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/payment-experience/web-profiles";
        String payLoad = "";
        return WebProfile.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, WebProfileList.class);
    }

    public void delete(String accessToken) throws PayPalRESTException {
        APIContext apiContext = new APIContext(accessToken);
        this.delete(apiContext);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (this.getId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getId()};
        String pattern = "v1/payment-experience/web-profiles/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        WebProfile.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getTemporary() {
        return this.temporary;
    }

    public FlowConfig getFlowConfig() {
        return this.flowConfig;
    }

    public InputFields getInputFields() {
        return this.inputFields;
    }

    public Presentation getPresentation() {
        return this.presentation;
    }

    public WebProfile setId(String id) {
        this.id = id;
        return this;
    }

    public WebProfile setName(String name) {
        this.name = name;
        return this;
    }

    public WebProfile setTemporary(Boolean temporary) {
        this.temporary = temporary;
        return this;
    }

    public WebProfile setFlowConfig(FlowConfig flowConfig) {
        this.flowConfig = flowConfig;
        return this;
    }

    public WebProfile setInputFields(InputFields inputFields) {
        this.inputFields = inputFields;
        return this;
    }

    public WebProfile setPresentation(Presentation presentation) {
        this.presentation = presentation;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WebProfile)) {
            return false;
        }
        WebProfile other = (WebProfile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$temporary = this.getTemporary();
        Boolean other$temporary = other.getTemporary();
        if (this$temporary == null ? other$temporary != null : !((Object)this$temporary).equals(other$temporary)) {
            return false;
        }
        FlowConfig this$flowConfig = this.getFlowConfig();
        FlowConfig other$flowConfig = other.getFlowConfig();
        if (this$flowConfig == null ? other$flowConfig != null : !((Object)this$flowConfig).equals(other$flowConfig)) {
            return false;
        }
        InputFields this$inputFields = this.getInputFields();
        InputFields other$inputFields = other.getInputFields();
        if (this$inputFields == null ? other$inputFields != null : !((Object)this$inputFields).equals(other$inputFields)) {
            return false;
        }
        Presentation this$presentation = this.getPresentation();
        Presentation other$presentation = other.getPresentation();
        return !(this$presentation == null ? other$presentation != null : !((Object)this$presentation).equals(other$presentation));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof WebProfile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $temporary = this.getTemporary();
        result = result * 59 + ($temporary == null ? 43 : ((Object)$temporary).hashCode());
        FlowConfig $flowConfig = this.getFlowConfig();
        result = result * 59 + ($flowConfig == null ? 43 : ((Object)$flowConfig).hashCode());
        InputFields $inputFields = this.getInputFields();
        result = result * 59 + ($inputFields == null ? 43 : ((Object)$inputFields).hashCode());
        Presentation $presentation = this.getPresentation();
        result = result * 59 + ($presentation == null ? 43 : ((Object)$presentation).hashCode());
        return result;
    }
}

