/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.api.payments;

import com.google.gson.annotations.SerializedName;
import com.paypal.api.payments.TemplateData;
import com.paypal.api.payments.TemplateSettings;
import com.paypal.api.payments.Templates;
import com.paypal.base.rest.APIContext;
import com.paypal.base.rest.HttpMethod;
import com.paypal.base.rest.PayPalRESTException;
import com.paypal.base.rest.PayPalResource;
import com.paypal.base.rest.RESTUtil;
import java.util.List;

public class Template
extends PayPalResource {
    private String templateId;
    private String name;
    @SerializedName(value="default")
    private Boolean isDefault;
    private TemplateData templateData;
    private List<TemplateSettings> settings;
    private String unitOfMeasure;
    private Boolean custom;

    public static Template get(APIContext apiContext, String templateId) throws PayPalRESTException {
        if (templateId == null) {
            throw new IllegalArgumentException("templateId cannot be null");
        }
        Object[] parameters = new Object[]{templateId};
        String pattern = "v1/invoicing/templates/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        return Template.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Template.class);
    }

    public static Templates getAll(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/invoicing/templates";
        String payLoad = "";
        return Template.configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Templates.class);
    }

    public void delete(APIContext apiContext) throws PayPalRESTException {
        if (this.getTemplateId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        apiContext.setMaskRequestId(true);
        Object[] parameters = new Object[]{this.getTemplateId()};
        String pattern = "v1/invoicing/templates/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = "";
        Template.configureAndExecute(apiContext, HttpMethod.DELETE, resourcePath, payLoad, null);
    }

    public Template create(APIContext apiContext) throws PayPalRESTException {
        String resourcePath = "v1/invoicing/templates";
        String payLoad = this.toJSON();
        return Template.configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Template.class);
    }

    public Template update(APIContext apiContext) throws PayPalRESTException {
        if (this.getTemplateId() == null) {
            throw new IllegalArgumentException("Id cannot be null");
        }
        Object[] parameters = new Object[]{this.getTemplateId()};
        String pattern = "v1/invoicing/templates/{0}";
        String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
        String payLoad = this.toJSON();
        return Template.configureAndExecute(apiContext, HttpMethod.PUT, resourcePath, payLoad, Template.class);
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getIsDefault() {
        return this.isDefault;
    }

    public TemplateData getTemplateData() {
        return this.templateData;
    }

    public List<TemplateSettings> getSettings() {
        return this.settings;
    }

    public String getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public Boolean getCustom() {
        return this.custom;
    }

    public Template setTemplateId(String templateId) {
        this.templateId = templateId;
        return this;
    }

    public Template setName(String name) {
        this.name = name;
        return this;
    }

    public Template setIsDefault(Boolean isDefault) {
        this.isDefault = isDefault;
        return this;
    }

    public Template setTemplateData(TemplateData templateData) {
        this.templateData = templateData;
        return this;
    }

    public Template setSettings(List<TemplateSettings> settings) {
        this.settings = settings;
        return this;
    }

    public Template setUnitOfMeasure(String unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
        return this;
    }

    public Template setCustom(Boolean custom) {
        this.custom = custom;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Template)) {
            return false;
        }
        Template other = (Template)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$templateId = this.getTemplateId();
        String other$templateId = other.getTemplateId();
        if (this$templateId == null ? other$templateId != null : !this$templateId.equals(other$templateId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Boolean this$isDefault = this.getIsDefault();
        Boolean other$isDefault = other.getIsDefault();
        if (this$isDefault == null ? other$isDefault != null : !((Object)this$isDefault).equals(other$isDefault)) {
            return false;
        }
        TemplateData this$templateData = this.getTemplateData();
        TemplateData other$templateData = other.getTemplateData();
        if (this$templateData == null ? other$templateData != null : !((Object)this$templateData).equals(other$templateData)) {
            return false;
        }
        List<TemplateSettings> this$settings = this.getSettings();
        List<TemplateSettings> other$settings = other.getSettings();
        if (this$settings == null ? other$settings != null : !((Object)this$settings).equals(other$settings)) {
            return false;
        }
        String this$unitOfMeasure = this.getUnitOfMeasure();
        String other$unitOfMeasure = other.getUnitOfMeasure();
        if (this$unitOfMeasure == null ? other$unitOfMeasure != null : !this$unitOfMeasure.equals(other$unitOfMeasure)) {
            return false;
        }
        Boolean this$custom = this.getCustom();
        Boolean other$custom = other.getCustom();
        return !(this$custom == null ? other$custom != null : !((Object)this$custom).equals(other$custom));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Template;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        String $templateId = this.getTemplateId();
        result = result * 59 + ($templateId == null ? 43 : $templateId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Boolean $isDefault = this.getIsDefault();
        result = result * 59 + ($isDefault == null ? 43 : ((Object)$isDefault).hashCode());
        TemplateData $templateData = this.getTemplateData();
        result = result * 59 + ($templateData == null ? 43 : ((Object)$templateData).hashCode());
        List<TemplateSettings> $settings = this.getSettings();
        result = result * 59 + ($settings == null ? 43 : ((Object)$settings).hashCode());
        String $unitOfMeasure = this.getUnitOfMeasure();
        result = result * 59 + ($unitOfMeasure == null ? 43 : $unitOfMeasure.hashCode());
        Boolean $custom = this.getCustom();
        result = result * 59 + ($custom == null ? 43 : ((Object)$custom).hashCode());
        return result;
    }
}

