/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core.soap;

import com.paypal.core.AuthenticationStrategy;
import com.paypal.core.credential.SignatureCredential;
import com.paypal.core.credential.SubjectAuthorization;
import com.paypal.core.credential.ThirdPartyAuthorization;
import com.paypal.core.credential.TokenAuthorization;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureSOAPHeaderAuthStrategy
implements AuthenticationStrategy<String, SignatureCredential> {
    private ThirdPartyAuthorization thirdPartyAuthorization;

    public ThirdPartyAuthorization getThirdPartyAuthorization() {
        return this.thirdPartyAuthorization;
    }

    public void setThirdPartyAuthorization(ThirdPartyAuthorization thirdPartyAuthorization) {
        this.thirdPartyAuthorization = thirdPartyAuthorization;
    }

    @Override
    public String generateHeaderStrategy(SignatureCredential credential) {
        String payLoad = this.thirdPartyAuthorization instanceof TokenAuthorization ? this.tokenAuthPayLoad() : (this.thirdPartyAuthorization instanceof SubjectAuthorization ? this.authPayLoad(credential, (SubjectAuthorization)this.thirdPartyAuthorization) : this.authPayLoad(credential, null));
        return payLoad;
    }

    private String tokenAuthPayLoad() {
        StringBuilder soapMsg = new StringBuilder();
        soapMsg.append("<ns:RequesterCredentials/>");
        return soapMsg.toString();
    }

    private String authPayLoad(SignatureCredential credential, SubjectAuthorization subjectAuth) {
        StringBuilder soapMsg = new StringBuilder();
        soapMsg.append("<ns:RequesterCredentials>");
        soapMsg.append("<ebl:Credentials>");
        soapMsg.append("<ebl:Username>" + credential.getUserName() + "</ebl:Username>");
        soapMsg.append("<ebl:Password>" + credential.getPassword() + "</ebl:Password>");
        soapMsg.append("<ebl:Signature>" + credential.getSignature() + "</ebl:Signature>");
        if (subjectAuth != null) {
            soapMsg.append("<ebl:Subject>" + subjectAuth.getSubject() + "</ebl:Subject>");
        }
        soapMsg.append("</ebl:Credentials>");
        soapMsg.append("</ns:RequesterCredentials>");
        return soapMsg.toString();
    }
}

