/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.AuthenticationStrategy;
import com.paypal.core.credential.CertificateCredential;
import com.paypal.core.credential.TokenAuthorization;
import com.paypal.sdk.exceptions.OAuthException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCertificateHttpHeaderAuthStrategy
implements AuthenticationStrategy<Map<String, String>, CertificateCredential> {
    protected String endPointUrl;

    public AbstractCertificateHttpHeaderAuthStrategy(String endPointUrl) {
        this.endPointUrl = endPointUrl;
    }

    @Override
    public Map<String, String> generateHeaderStrategy(CertificateCredential credential) throws OAuthException {
        HashMap<String, String> headers;
        if (credential.getThirdPartyAuthorization() instanceof TokenAuthorization) {
            headers = this.processTokenAuthorization(credential, (TokenAuthorization)credential.getThirdPartyAuthorization());
        } else {
            headers = new HashMap<String, String>();
            headers.put("X-PAYPAL-SECURITY-USERID", credential.getUserName());
            headers.put("X-PAYPAL-SECURITY-PASSWORD", credential.getPassword());
        }
        return headers;
    }

    protected abstract Map<String, String> processTokenAuthorization(CertificateCredential var1, TokenAuthorization var2) throws OAuthException;
}

