/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.payments;

import com.paypal.http.HttpRequest;
import com.paypal.payments.Capture;
import com.paypal.payments.CaptureRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

public class AuthorizationsCaptureRequest
extends HttpRequest<Capture> {
    public AuthorizationsCaptureRequest(String authorizationId) {
        super("/v2/payments/authorizations/{authorization_id}/capture?", "POST", Capture.class);
        try {
            this.path(this.path().replace("{authorization_id}", URLEncoder.encode(String.valueOf(authorizationId), "UTF-8")));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.header("Content-Type", "application/json");
    }

    public AuthorizationsCaptureRequest payPalRequestId(String payPalRequestId) {
        this.header("PayPal-Request-Id", String.valueOf(payPalRequestId));
        return this;
    }

    public AuthorizationsCaptureRequest prefer(String prefer) {
        this.header("Prefer", String.valueOf(prefer));
        return this;
    }

    public AuthorizationsCaptureRequest requestBody(CaptureRequest capture) {
        super.requestBody((Object)capture);
        return this;
    }
}

