/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.core;

import com.paypal.core.PayPalEnvironment;
import com.paypal.core.PayPalHttpClient;
import com.paypal.core.cache.MemoryCache;
import com.paypal.core.object.AccessToken;
import com.paypal.core.request.AccessTokenRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class AuthorizationProvider {
    private static final AuthorizationProvider sharedInstance = new AuthorizationProvider();
    private static final Map<String, Object> locks = Collections.synchronizedMap(new HashMap());
    private MemoryCache<AccessToken> authorizationCache = new MemoryCache();

    public static AuthorizationProvider sharedInstance() {
        return sharedInstance;
    }

    private AuthorizationProvider() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken authorize(PayPalHttpClient client, String refreshToken) throws IOException {
        String mapKey = this.mapKey(client.getPayPalEnvironment(), refreshToken);
        AccessToken existingToken = this.authorizationCache.get(mapKey);
        if (existingToken == null || existingToken.isExpired()) {
            Object lock;
            Object object = lock = this.getLock(mapKey);
            synchronized (object) {
                existingToken = this.authorizationCache.get(mapKey);
                if (existingToken == null || existingToken.isExpired()) {
                    existingToken = this.fetchAccessToken(client, refreshToken);
                    this.authorizationCache.put(mapKey, existingToken);
                }
            }
        }
        return this.authorizationCache.get(mapKey);
    }

    private Object getLock(String key) {
        return locks.computeIfAbsent(key, k -> new Object());
    }

    private AccessToken fetchAccessToken(PayPalHttpClient client, String refreshToken) throws IOException {
        AccessTokenRequest request = refreshToken == null ? new AccessTokenRequest(client.getPayPalEnvironment()) : new AccessTokenRequest(client.getPayPalEnvironment(), refreshToken);
        return (AccessToken)client.execute(request).result();
    }

    private String mapKey(PayPalEnvironment environment, String refreshToken) {
        String key = environment.authorizationString();
        if (refreshToken != null) {
            key = key + "_" + refreshToken;
        }
        return key;
    }
}

