/*
 * Decompiled with CFR 0.152.
 */
package com.paypal.http.serializer;

import com.paypal.http.HttpRequest;
import com.paypal.http.exceptions.SerializeException;
import com.paypal.http.serializer.Serializer;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;

public class FormEncoded
implements Serializer {
    @Override
    public String contentType() {
        return "^application/x-www-form-urlencoded";
    }

    @Override
    public byte[] encode(HttpRequest request) throws IOException {
        if (!(request.requestBody() instanceof Map)) {
            throw new SerializeException("Request requestBody must be Map<String, String> when Content-Type is application/x-www-form-urlencoded");
        }
        Map body = (Map)request.requestBody();
        ArrayList<String> parts = new ArrayList<String>(body.size());
        for (String key : body.keySet()) {
            parts.add(key + "=" + FormEncoded.urlEscape((String)body.get(key)));
        }
        return String.join((CharSequence)"&", parts).getBytes(StandardCharsets.UTF_8);
    }

    @Override
    public <T> T decode(String source, Class<T> cls) throws IOException {
        throw new UnsupportedEncodingException("Unable to decode Content-Type: " + this.contentType());
    }

    public static String urlEscape(String input) {
        try {
            return URLEncoder.encode(input, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }
}

