/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.HasUniqueId;
import com.palantir.javaformat.doc.ImmutableBreakState;
import com.palantir.javaformat.doc.ImmutableState;
import com.palantir.javaformat.doc.Level;
import fj.data.Set;
import fj.data.TreeMap;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableState.class)
@Immutable
@Value.Immutable
@Value.Style(overshadowImplementation=true)
public abstract class State {
    public abstract int lastIndent();

    public abstract int indent();

    public abstract int column();

    public abstract boolean mustBreak();

    public abstract int numLines();

    public abstract int branchingCoefficient();

    @JsonIgnore
    @Value.Auxiliary
    protected abstract Set<BreakTag> breakTagsTaken();

    @JsonIgnore
    @Value.Auxiliary
    protected abstract TreeMap<Break, BreakState> breakStates();

    @JsonIgnore
    @Value.Auxiliary
    protected abstract TreeMap<Level, LevelState> levelStates();

    @JsonIgnore
    @Value.Auxiliary
    protected abstract TreeMap<Comment, TokState> tokStates();

    public static State startingState() {
        return State.builder().lastIndent(0).indent(0).column(0).mustBreak(false).numLines(0).branchingCoefficient(0).breakTagsTaken((Set<BreakTag>)Set.empty(HasUniqueId.ord())).breakStates((TreeMap<Break, BreakState>)TreeMap.empty(HasUniqueId.ord())).levelStates((TreeMap<Level, LevelState>)TreeMap.empty(HasUniqueId.ord())).tokStates((TreeMap<Comment, TokState>)TreeMap.empty(HasUniqueId.ord())).build();
    }

    public BreakState getBreakState(Break brk) {
        return (BreakState)this.breakStates().get((Object)brk).orSome((Object)ImmutableBreakState.of(false, -1));
    }

    public boolean wasBreakTaken(BreakTag breakTag) {
        return this.breakTagsTaken().member((Object)breakTag);
    }

    boolean isOneLine(Level level) {
        LevelState levelState = (LevelState)this.levelStates().get((Object)level).toNull();
        return levelState != null && levelState.oneLine();
    }

    String getTokText(Comment comment) {
        return (String)this.tokStates().get((Object)comment).map(TokState::text).orSome(comment::getFlat);
    }

    State breakTaken(BreakTag breakTag, boolean broken) {
        boolean currentlyBroken = this.breakTagsTaken().member((Object)breakTag);
        if (currentlyBroken != broken) {
            Set newSet = broken ? this.breakTagsTaken().insert((Object)breakTag) : this.breakTagsTaken().delete((Object)breakTag);
            return State.builder().from(this).breakTagsTaken((Set<BreakTag>)newSet).build();
        }
        return this;
    }

    State withIndentIncrementedBy(Indent plusIndent) {
        return State.builder().from(this).indent(this.indent() + plusIndent.eval(this)).mustBreak(false).build();
    }

    State withNoIndent() {
        return State.builder().from(this).indent(this.lastIndent()).mustBreak(false).build();
    }

    State withBrokenLevel() {
        return State.builder().from(this).lastIndent(this.indent()).build();
    }

    State withBreak(Break brk, boolean broken) {
        Builder builder = State.builder().from(this);
        if (broken) {
            int newColumn = Math.max(this.indent() + brk.evalPlusIndent(this), 0);
            return builder.lastIndent(this.indent()).column(newColumn).numLines(this.numLines() + 1).breakStates((TreeMap<Break, BreakState>)this.breakStates().set((Object)brk, (Object)ImmutableBreakState.of(true, newColumn))).build();
        }
        return builder.column(this.column() + brk.getFlat().length()).build();
    }

    State updateAfterLevel(State afterInnerLevel) {
        return State.builder().lastIndent(this.lastIndent()).indent(this.indent()).branchingCoefficient(this.branchingCoefficient()).mustBreak(this.mustBreak()).column(afterInnerLevel.column()).numLines(afterInnerLevel.numLines()).breakTagsTaken(afterInnerLevel.breakTagsTaken()).breakStates(afterInnerLevel.breakStates()).levelStates(afterInnerLevel.levelStates()).tokStates(afterInnerLevel.tokStates()).build();
    }

    State addNewLines(int extraNewlines) {
        return State.builder().from(this).numLines(this.numLines() + extraNewlines).build();
    }

    State withColumn(int column) {
        return State.builder().from(this).column(column).build();
    }

    State withMustBreak(boolean mustBreak) {
        return State.builder().from(this).mustBreak(mustBreak).build();
    }

    State withNewBranch() {
        return State.builder().from(this).branchingCoefficient(this.branchingCoefficient() + 1).build();
    }

    State withLevelState(Level level, LevelState levelState) {
        return State.builder().from(this).levelStates((TreeMap<Level, LevelState>)this.levelStates().set((Object)level, (Object)levelState)).build();
    }

    State withTokState(Comment comment, TokState tokState) {
        return State.builder().from(this).tokStates((TreeMap<Comment, TokState>)this.tokStates().set((Object)comment, (Object)tokState)).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableState.Builder {
    }

    @JsonSerialize(as=ImmutableBreakState.class)
    @Value.Immutable
    static interface BreakState {
        @Value.Parameter
        public boolean broken();

        @Value.Parameter
        public int newIndent();
    }

    @Value.Immutable
    static interface LevelState {
        @Value.Parameter
        public boolean oneLine();
    }

    @Value.Immutable
    static interface TokState {
        @Value.Parameter
        public String text();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Value.Style(overshadowImplementation=true)
    static @interface TokStateStyle {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Value.Style(overshadowImplementation=true)
    static @interface LevelStateStyle {
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.SOURCE)
    @Value.Style(overshadowImplementation=true)
    static @interface BreakStateStyle {
    }
}

