/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.google.common.collect.Range;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.CommentsHelper;
import com.palantir.javaformat.Indent;
import com.palantir.javaformat.Op;
import com.palantir.javaformat.Output;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.Doc;
import com.palantir.javaformat.doc.DocBuilder;
import com.palantir.javaformat.doc.FillMode;
import com.palantir.javaformat.doc.ImmutableBreak;
import com.palantir.javaformat.doc.Obs;
import com.palantir.javaformat.doc.State;
import java.util.Optional;
import org.immutables.value.Value;

@Immutable
@Value.Immutable
public abstract class Break
extends Doc
implements Op {
    public abstract FillMode fillMode();

    public abstract String flat();

    public abstract Indent plusIndent();

    public abstract Optional<BreakTag> optTag();

    public abstract boolean hasColumnLimit();

    public static Break make(FillMode fillMode, String flat, Indent plusIndent) {
        return Break.builder().fillMode(fillMode).flat(flat).plusIndent(plusIndent).hasColumnLimit(false).build();
    }

    public static Break make(FillMode fillMode, String flat, Indent plusIndent, Optional<BreakTag> optTag) {
        return Break.builder().fillMode(fillMode).flat(flat).plusIndent(plusIndent).optTag(optTag).hasColumnLimit(false).build();
    }

    public static Break makeForced() {
        return Break.builder().fillMode(FillMode.FORCED).flat("").plusIndent(Indent.Const.ZERO).hasColumnLimit(false).build();
    }

    public int evalPlusIndent(State state) {
        return this.plusIndent().eval(state);
    }

    public boolean isForced() {
        return this.fillMode() == FillMode.FORCED;
    }

    @Override
    public void add(DocBuilder builder) {
        builder.breakDoc(this);
    }

    @Override
    protected float computeWidth() {
        return this.isForced() ? Float.POSITIVE_INFINITY : (float)this.flat().length();
    }

    @Override
    protected String computeFlat() {
        return this.flat();
    }

    @Override
    protected Range<Integer> computeRange() {
        return EMPTY_RANGE;
    }

    public State computeBreaks(State stateIn, boolean broken) {
        State state = this.optTag().map(breakTag -> stateIn.breakTaken((BreakTag)breakTag, broken)).orElse(stateIn);
        return state.withBreak(this, broken);
    }

    @Override
    public State computeBreaks(CommentsHelper commentsHelper, int maxWidth, State state, Obs.ExplorationNode observationNode) {
        throw new UnsupportedOperationException("Did you mean computeBreaks(State, int, boolean)?");
    }

    @Override
    public void write(State state, Output output) {
        State.BreakState breakState = state.getBreakState(this);
        if (breakState.broken()) {
            output.append(state, "\n", (Range<Integer>)EMPTY_RANGE);
            output.indent(breakState.newIndent());
        } else {
            output.append(state, this.flat(), this.range());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends ImmutableBreak.Builder {
    }
}

