/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat.doc;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import com.palantir.javaformat.doc.Break;
import com.palantir.javaformat.doc.Comment;
import com.palantir.javaformat.doc.DocVisitor;
import com.palantir.javaformat.doc.Level;
import com.palantir.javaformat.doc.NonBreakingSpace;
import com.palantir.javaformat.doc.State;
import com.palantir.javaformat.doc.Token;

public final class JsonDocVisitor
implements DocVisitor<JsonNode> {
    private static final ObjectMapper MAPPER = new ObjectMapper().registerModule((Module)new ParameterNamesModule()).registerModule((Module)new Jdk8Module());
    private final State state;

    public JsonDocVisitor(State state) {
        this.state = state;
    }

    @Override
    public JsonNode visitSpace(NonBreakingSpace doc) {
        return MAPPER.createObjectNode().put("type", "space").put("id", doc.id());
    }

    @Override
    public JsonNode visitComment(Comment doc) {
        return MAPPER.createObjectNode().put("type", "comment").put("flat", doc.getFlat()).put("text", this.state.getTokText(doc)).put("id", doc.id());
    }

    @Override
    public JsonNode visitToken(Token doc) {
        return MAPPER.createObjectNode().put("type", "token").put("flat", doc.getFlat()).put("id", doc.id());
    }

    @Override
    public JsonNode visitBreak(Break doc) {
        return ((ObjectNode)((ObjectNode)((ObjectNode)MAPPER.createObjectNode().put("type", "break").put("flat", doc.getFlat()).set("breakState", MAPPER.valueToTree((Object)this.state.getBreakState(doc)))).set("plusIndent", MAPPER.valueToTree((Object)doc.plusIndent()))).set("optTag", MAPPER.valueToTree(doc.optTag()))).put("evalPlusIndent", doc.evalPlusIndent(this.state)).put("id", doc.id());
    }

    @Override
    public JsonNode visitLevel(Level level) {
        ObjectNode node = MAPPER.createObjectNode();
        node.put("type", "level");
        node.put("flat", level.getFlat());
        node.put("id", level.id());
        node.set("openOp", MAPPER.valueToTree((Object)level.getOpenOp()));
        node.put("isOneLine", this.state.isOneLine(level));
        node.put("evalPlusIndent", level.getPlusIndent().eval(this.state));
        node.set("docs", MAPPER.valueToTree(level.getDocs().stream().map(this::visit)));
        return node;
    }
}

