/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.google.common.collect.Iterators;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import com.palantir.javaformat.Newlines;
import com.palantir.javaformat.java.Replacement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;

public final class Utils {
    private Utils() {
    }

    public static String applyReplacements(String input, Collection<Replacement> replacementsCollection) {
        ArrayList<Replacement> replacements = new ArrayList<Replacement>(replacementsCollection);
        replacements.sort(Comparator.comparing(r -> (Integer)r.getReplaceRange().lowerEndpoint()).reversed());
        StringBuilder writer = new StringBuilder(input);
        for (Replacement replacement : replacements) {
            writer.replace((Integer)replacement.getReplaceRange().lowerEndpoint(), (Integer)replacement.getReplaceRange().upperEndpoint(), replacement.getReplacementString());
        }
        return writer.toString();
    }

    public static RangeSet<Integer> lineRangesToCharRanges(String input, RangeSet<Integer> lineRanges) {
        ArrayList<Integer> lines = new ArrayList<Integer>();
        Iterators.addAll(lines, Newlines.lineOffsetIterator(input));
        lines.add(input.length() + 1);
        TreeRangeSet characterRanges = TreeRangeSet.create();
        for (Range lineRange : lineRanges.subRangeSet(Range.closedOpen((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(lines.size() - 1))).asRanges()) {
            int lineStart = (Integer)lines.get((Integer)lineRange.lowerEndpoint());
            int lineEnd = (Integer)lines.get((Integer)lineRange.upperEndpoint()) - 1;
            Range range = Range.closedOpen((Comparable)Integer.valueOf(lineStart), (Comparable)Integer.valueOf(lineEnd));
            characterRanges.add(range);
        }
        return characterRanges;
    }
}

