/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.javaformat;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.Immutable;
import com.palantir.javaformat.doc.BreakTag;
import com.palantir.javaformat.doc.State;

@Immutable
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
public abstract class Indent {
    public abstract int eval(State var1);

    @JsonTypeName(value="if")
    public static final class If
    extends Indent {
        @JsonProperty
        private final BreakTag condition;
        @JsonProperty
        private final Indent thenIndent;
        @JsonProperty
        private final Indent elseIndent;

        private If(BreakTag condition, Indent thenIndent, Indent elseIndent) {
            this.condition = condition;
            this.thenIndent = thenIndent;
            this.elseIndent = elseIndent;
        }

        public static If make(BreakTag condition, Indent thenIndent, Indent elseIndent) {
            return new If(condition, thenIndent, elseIndent);
        }

        @Override
        public int eval(State state) {
            return (state.wasBreakTaken(this.condition) ? this.thenIndent : this.elseIndent).eval(state);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("condition", (Object)this.condition).add("thenIndent", (Object)this.thenIndent).add("elseIndent", (Object)this.elseIndent).toString();
        }
    }

    @JsonTypeName(value="const")
    public static final class Const
    extends Indent {
        @JsonProperty(value="amount")
        private final int n;
        public static final Const ZERO = new Const(0);

        private Const(int n) {
            this.n = n;
        }

        public static Const make(int n, int indentMultiplier) {
            return new Const(n * indentMultiplier);
        }

        @Override
        public int eval(State _state) {
            return this.n;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("n", this.n).toString();
        }
    }
}

