/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone.safety;

import org.checkerframework.errorprone.dataflow.analysis.AbstractValue;

public enum Safety implements AbstractValue<Safety>
{
    UNKNOWN{

        public Safety leastUpperBound(Safety other) {
            return other == SAFE ? this : 1.nullToUnknown(other);
        }

        @Override
        public boolean allowsValueWith(Safety _valueSafety) {
            return true;
        }
    }
    ,
    DO_NOT_LOG{

        public Safety leastUpperBound(Safety _other) {
            return this;
        }

        @Override
        public boolean allowsValueWith(Safety _valueSafety) {
            return true;
        }
    }
    ,
    UNSAFE{

        public Safety leastUpperBound(Safety other) {
            return other == DO_NOT_LOG ? other : this;
        }

        @Override
        public boolean allowsValueWith(Safety valueSafety) {
            return 3.nullToUnknown(valueSafety) != DO_NOT_LOG;
        }
    }
    ,
    SAFE{

        public Safety leastUpperBound(Safety other) {
            return 4.nullToUnknown(other);
        }

        @Override
        public boolean allowsValueWith(Safety valueSafety) {
            return 4.nullToUnknown(valueSafety) == UNKNOWN || valueSafety == SAFE;
        }
    };


    public abstract boolean allowsValueWith(Safety var1);

    public boolean allowsAll() {
        return this == UNKNOWN || this == DO_NOT_LOG;
    }

    public static Safety mergeAssumingUnknownIsSame(Safety first, Safety second) {
        Safety one = Safety.nullToUnknown(first);
        Safety two = Safety.nullToUnknown(second);
        if (one == UNKNOWN) {
            return two;
        }
        if (two == UNKNOWN) {
            return one;
        }
        return (Safety)one.leastUpperBound(two);
    }

    public static Safety mergeAssumingUnknownIsSame(Safety one, Safety two, Safety three) {
        Safety result = Safety.mergeAssumingUnknownIsSame(one, two);
        return Safety.mergeAssumingUnknownIsSame(result, Safety.nullToUnknown(three));
    }

    static Safety nullToUnknown(Safety input) {
        return input == null ? UNKNOWN : input;
    }
}

