/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.time.ZoneId;
import java.time.ZoneOffset;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer ZoneId constants.")
@AutoService(value={BugChecker.class})
public final class ZoneIdConstant
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ZONE_ID_OF = Matchers.staticMethod().onClass(ZoneId.class.getName()).named("of").withParameters(String.class.getName(), new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String zone;
        if (ZONE_ID_OF.matches((Tree)tree, state) && (zone = (String)ASTHelpers.constValue((Tree)tree.getArguments().get(0), String.class)) != null && (zone.equals("Z") || zone.equals("UTC"))) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            return this.buildDescription(tree).addFix((Fix)fix.replace((Tree)tree, SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)ZoneOffset.class.getName()) + ".UTC").build()).build();
        }
        return Description.NO_MATCH;
    }
}

