/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Symbol;
import java.io.Serializable;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Using TaggedMetricRegistry.gauge is equivalent to map.putIfAbsent, and can result in subtle resource leaks. Prefer replacing existing gauge values.\nThis can be fixed automatically using ./gradlew compileJava compileTestJava -PerrorProneApply=UnsafeGaugeRegistration")
@AutoService(value={BugChecker.class})
public final class UnsafeGaugeRegistration
extends AbstractReturnValueIgnored {
    private static final String TAGGED_REGISTRY = "com.palantir.tritium.metrics.registry.TaggedMetricRegistry";
    private static final String REGISTER_WITH_REPLACEMENT = "registerWithReplacement";
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onDescendantOf("com.palantir.tritium.metrics.registry.TaggedMetricRegistry").named("gauge").withParameters("com.palantir.tritium.metrics.registry.MetricName", new String[]{"com.codahale.metrics.Gauge"});
    private static final Supplier<Symbol> TAGGED_METRIC_REGISTRY = VisitorState.memoize((Supplier & Serializable)state -> state.getSymbolFromString(TAGGED_REGISTRY));

    public Matcher<? super ExpressionTree> specializedMatcher() {
        return MATCHER;
    }

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState state) {
        Description description = super.matchMethodInvocation(methodInvocationTree, state);
        if (Description.NO_MATCH.equals(description) || !UnsafeGaugeRegistration.hasRegisterWithReplacement(state) || TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(methodInvocationTree).addFix((Fix)SuggestedFixes.renameMethodInvocation((MethodInvocationTree)methodInvocationTree, (String)REGISTER_WITH_REPLACEMENT, (VisitorState)state)).build();
    }

    private static boolean hasRegisterWithReplacement(VisitorState state) {
        Symbol symbol = (Symbol)TAGGED_METRIC_REGISTRY.get(state);
        if (!(symbol instanceof Symbol.ClassSymbol)) {
            return false;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
        for (Symbol enclosed : classSymbol.getEnclosedElements()) {
            if (!(enclosed instanceof Symbol.MethodSymbol)) continue;
            Symbol.MethodSymbol enclosedMethod = (Symbol.MethodSymbol)enclosed;
            if (!enclosedMethod.name.contentEquals(REGISTER_WITH_REPLACEMENT)) continue;
            return true;
        }
        return false;
    }
}

