/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Allow only com.palantir.logsafe.Arg types, or vararg arrays, as parameter inputs to slf4j log messages.")
@AutoService(value={BugChecker.class})
public final class Slf4jLogsafeArgs
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> LOG_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").withNameMatching(Pattern.compile("trace|debug|info|warn|error"));
    private static final Supplier<Type> JAVA_OBJECT = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("java.lang.Object"));
    private static final Matcher<ExpressionTree> THROWABLE = MoreMatchers.isSubtypeOf(Throwable.class);
    private static final Matcher<ExpressionTree> ARG = MoreMatchers.isSubtypeOf("com.palantir.logsafe.Arg");
    private static final Matcher<ExpressionTree> MARKER = MoreMatchers.isSubtypeOf("org.slf4j.Marker");
    private static final Matcher<Tree> OBJECT_ARRAY = Matchers.isSubtypeOf((Supplier & Serializable)s -> s.getType((Type)JAVA_OBJECT.get(s), true, Collections.emptyList()));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!LOG_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        Optional<Description> wrappedThrowableDescription = this.checkThrowableArgumentNotWrapped(tree, state);
        if (wrappedThrowableDescription.isPresent()) {
            return wrappedThrowableDescription.get();
        }
        List<? extends ExpressionTree> allArgs = tree.getArguments();
        int startArgIndex = MARKER.matches((Tree)allArgs.get(0), state) ? 2 : 1;
        int lastArgIndex = allArgs.size() - 1;
        ExpressionTree lastArg = allArgs.get(lastArgIndex);
        if (startArgIndex == lastArgIndex && OBJECT_ARRAY.matches((Tree)lastArg, state)) {
            return Description.NO_MATCH;
        }
        boolean lastArgIsThrowable = THROWABLE.matches((Tree)lastArg, state);
        int lastNonThrowableArgIndex = lastArgIsThrowable ? lastArgIndex - 1 : lastArgIndex;
        List<Integer> badArgs = this.getBadArgIndices(state, allArgs, startArgIndex, lastNonThrowableArgIndex);
        if (badArgs.isEmpty() || TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("slf4j log statement does not use logsafe parameters for arguments " + badArgs).build();
    }

    private List<Integer> getBadArgIndices(VisitorState state, List<? extends ExpressionTree> args, int from, int to) {
        ImmutableList.Builder badArgsBuilder = ImmutableList.builder();
        for (int i = from; i <= to; ++i) {
            if (ARG.matches((Tree)args.get(i), state)) continue;
            badArgsBuilder.add((Object)i);
        }
        return badArgsBuilder.build();
    }

    private Optional<Description> checkThrowableArgumentNotWrapped(MethodInvocationTree tree, VisitorState state) {
        ExpressionTree lastArg = tree.getArguments().get(tree.getArguments().size() - 1);
        boolean lastArgIsThrowable = THROWABLE.matches((Tree)lastArg, state);
        if (lastArgIsThrowable) {
            return Optional.empty();
        }
        return lastArg.accept(ThrowableArgVisitor.INSTANCE, state).map(node -> this.buildDescription(tree).setMessage("slf4j log statement should not use logsafe wrappers for throwables").addFix((Fix)SuggestedFix.replace((Tree)lastArg, (String)state.getSourceForNode((Tree)node))).build());
    }

    private static final class ThrowableArgVisitor
    extends SimpleTreeVisitor<Optional<ExpressionTree>, VisitorState> {
        private static final ThrowableArgVisitor INSTANCE = new ThrowableArgVisitor();
        private static final Matcher<ExpressionTree> ARG_FACTORY = Matchers.staticMethod().onClassAny(new String[]{"com.palantir.logsafe.SafeArg", "com.palantir.logsafe.UnsafeArg"}).named("of").withParameters(String.class.getName(), new String[]{Object.class.getName()});
        private static final Matcher<ExpressionTree> THROWABLE_ARG = Matchers.methodInvocation(ARG_FACTORY, (ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.LAST, THROWABLE);

        private ThrowableArgVisitor() {
            super(Optional.empty());
        }

        @Override
        public Optional<ExpressionTree> visitMethodInvocation(MethodInvocationTree node, VisitorState state) {
            if (THROWABLE_ARG.matches((Tree)node, state)) {
                return Optional.of(node.getArguments().get(1));
            }
            return Optional.empty();
        }
    }
}

