/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicates;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.util.regex.Pattern;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="use your webserver's managed resource functionality instead of using Runtime#addShutdownHook directly.")
@AutoService(value={BugChecker.class})
public final class ShutdownHook
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String errorMsg = "Use your webserver's managed resource functionality instead of using java.lang.Runtime#addShutdownHook directly.";
    private static final Matcher<ExpressionTree> shutdownHookMethods = MethodMatchers.instanceMethod().onClass(TypePredicates.isExactType((String)"java.lang.Runtime")).withNameMatching(Pattern.compile("addShutdownHook|removeShutdownHook"));

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!shutdownHookMethods.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(errorMsg).build();
    }
}

