/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="Prefer using type-safe safe-logging loggers rather than safety-oblivious implementations.")
@AutoService(value={BugChecker.class})
public final class PreferSafeLogger
extends BugChecker
implements BugChecker.VariableTreeMatcher {
    private static final int MAX_SUPPORTED_ARGS = 10;
    private static final Matcher<ExpressionTree> SLF4J_METHOD = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger");
    private static final Matcher<ExpressionTree> SLF4J_SAFE_METHODS = MethodMatchers.instanceMethod().onDescendantOf("org.slf4j.Logger").namedAnyOf(new String[]{"isTraceEnabled", "isDebugEnabled", "isInfoEnabled", "isWarnEnabled", "isErrorEnabled", "trace", "debug", "info", "warn", "error"});
    private static final Matcher<VariableTree> MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)"org.slf4j.Logger"), Matchers.variableInitializer((Matcher)MethodMatchers.staticMethod().onClass("org.slf4j.LoggerFactory").named("getLogger"))});
    private static final Supplier<Type> SAFE_LOGGER_ARG = VisitorState.memoize((Supplier & Serializable)state -> state.getTypeFromString("com.palantir.logsafe.Arg"));

    public Description matchVariable(VariableTree tree, final VisitorState state) {
        if (!MATCHER.matches((Tree)tree, state) || TestCheckUtils.isTestCode(state)) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)tree);
        final AtomicBoolean foundUnknownUsage = new AtomicBoolean();
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void _unused) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    foundUnknownUsage.set(true);
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void _unused) {
                if (sym.equals(ASTHelpers.getSymbol((Tree)tree))) {
                    foundUnknownUsage.set(true);
                }
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitMethodInvocation(MethodInvocationTree tree, Void _unused) {
                ExpressionTree receiver;
                if (SLF4J_METHOD.matches((Tree)tree, state) && sym.equals(ASTHelpers.getSymbol((Tree)(receiver = ASTHelpers.getReceiver((ExpressionTree)tree))))) {
                    if (!PreferSafeLogger.isSafeSlf4jInteraction(tree, fix, state)) {
                        foundUnknownUsage.set(true);
                    } else {
                        this.scan(tree.getArguments(), null);
                    }
                    return null;
                }
                return (Void)super.visitMethodInvocation(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (foundUnknownUsage.get()) {
            return this.describeMatch(tree);
        }
        String qualifiedLogger = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.palantir.logsafe.logger.SafeLogger");
        String qualifiedFactory = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"com.palantir.logsafe.logger.SafeLoggerFactory");
        fix.replace(tree.getType(), qualifiedLogger);
        MethodInvocationTree initializerInvocation = (MethodInvocationTree)tree.getInitializer();
        fix.replace((Tree)initializerInvocation.getMethodSelect(), qualifiedFactory + ".get");
        return this.buildDescription(tree).addFix((Fix)fix.build()).build();
    }

    private static boolean isSafeSlf4jInteraction(MethodInvocationTree tree, SuggestedFix.Builder fix, VisitorState state) {
        if (!SLF4J_SAFE_METHODS.matches((Tree)tree, state)) {
            return false;
        }
        List<? extends ExpressionTree> arguments = tree.getArguments();
        if (arguments.isEmpty()) {
            return true;
        }
        if (!state.getTypes().isSameType(ASTHelpers.getType((Tree)arguments.get(0)), state.getTypeFromString(String.class.getName()))) {
            return false;
        }
        Type argType = (Type)SAFE_LOGGER_ARG.get(state);
        Type throwableType = state.getTypeFromString(Throwable.class.getName());
        int args = 0;
        int firstArgStartPosition = -1;
        int lastArgEndPosition = -1;
        for (int i = 1; i < arguments.size(); ++i) {
            boolean valid;
            Tree argument = arguments.get(i);
            Type type = ASTHelpers.getType((Tree)argument);
            boolean isArg = ASTHelpers.isSubtype((Type)type, (Type)argType, (VisitorState)state);
            if (isArg) {
                if (i == 1) {
                    firstArgStartPosition = ASTHelpers.getStartPosition((Tree)argument);
                }
                ++args;
                lastArgEndPosition = state.getEndPosition(argument);
            }
            boolean bl = valid = isArg || ASTHelpers.isSubtype((Type)type, (Type)throwableType, (VisitorState)state) && i == arguments.size() - 1;
            if (valid) continue;
            return false;
        }
        if (args > 10) {
            CharSequence argsSource = state.getSourceCode().subSequence(firstArgStartPosition, lastArgEndPosition);
            String qualifiedArrays = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Arrays.class.getName());
            fix.replace(firstArgStartPosition, lastArgEndPosition, String.format("%s.asList(%s)", qualifiedArrays, argsSource));
        }
        return true;
    }
}

