/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Expression passed to Optional#orElse invokes a method, use Optional#orElseGet instead")
@AutoService(value={BugChecker.class})
public final class OptionalOrElseMethodInvocation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> OR_ELSE_METHOD = MethodMatchers.instanceMethod().onExactClass("java.util.Optional").named("orElse");
    private static final Matcher<ExpressionTree> METHOD_INVOCATIONS = Matchers.anyOf((Matcher[])new Matcher[]{MethodInvocationMatcher.INSTANCE, Matchers.contains(ExpressionTree.class, (Matcher)MethodInvocationMatcher.INSTANCE)});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!OR_ELSE_METHOD.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        ExpressionTree orElseArg = tree.getArguments().get(0);
        if (!METHOD_INVOCATIONS.matches((Tree)orElseArg, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Expression passed to Optional#orElse invokes a method").addFix((Fix)SuggestedFix.builder().postfixWith((Tree)tree.getMethodSelect(), "Get").prefixWith((Tree)orElseArg, "() -> ").build()).build();
    }

    private static enum MethodInvocationMatcher implements Matcher<ExpressionTree>
    {
        INSTANCE;


        public boolean matches(ExpressionTree tree, VisitorState state) {
            Tree.Kind kind = tree.getKind();
            return kind == Tree.Kind.NEW_CLASS || kind == Tree.Kind.METHOD_INVOCATION;
        }
    }
}

