/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.VisitorState;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import java.util.Comparator;
import java.util.Optional;
import javax.annotation.Nullable;

public final class MoreASTHelpers {
    static ImmutableList<Type> flattenTypesForAssignment(ImmutableList<Type> input, VisitorState state) {
        ImmutableList types = (ImmutableList)input.stream().map(type -> MoreASTHelpers.broadenAnonymousType(type, state)).collect(ImmutableList.toImmutableList());
        ImmutableList.Builder deduplicatedBuilder = ImmutableList.builderWithExpectedSize((int)types.size());
        for (int i = 0; i < types.size(); ++i) {
            Type current = (Type)types.get(i);
            boolean duplicate = false;
            for (int j = 0; j < i; ++j) {
                if (!ASTHelpers.isSameType((Type)((Type)types.get(j)), (Type)current, (VisitorState)state)) continue;
                duplicate = true;
                break;
            }
            if (duplicate) continue;
            deduplicatedBuilder.add((Object)current);
        }
        ImmutableList deduplicated = deduplicatedBuilder.build();
        return (ImmutableList)deduplicated.stream().filter(type -> deduplicated.stream().noneMatch(item -> type != item && state.getTypes().isSubtype((Type)type, (Type)item))).sorted(Comparator.comparing(type -> SuggestedFixes.prettyType((VisitorState)state, null, (Type)type))).collect(ImmutableList.toImmutableList());
    }

    private static Type broadenAnonymousType(Type input, VisitorState state) {
        Type upperBound = input.getUpperBound();
        if (upperBound != null) {
            return MoreASTHelpers.broadenAnonymousType(upperBound, state);
        }
        if (input.tsym.isAnonymous()) {
            return MoreASTHelpers.broadenAnonymousType(state.getTypes().supertype(input), state);
        }
        return input;
    }

    static ImmutableSet<Type> getThrownExceptionsFromTryBody(TryTree tree, VisitorState state) {
        ImmutableSet.Builder results = ImmutableSet.builder();
        results.addAll((Iterable)ASTHelpers.getThrownExceptions((Tree)tree.getBlock(), (VisitorState)state));
        tree.getResources().forEach(resource -> {
            results.addAll((Iterable)ASTHelpers.getThrownExceptions((Tree)resource, (VisitorState)state));
            Type resourceType = ASTHelpers.getType((Tree)resource);
            if (resourceType != null && resourceType.tsym instanceof Symbol.ClassSymbol) {
                MoreASTHelpers.getCloseMethod((Symbol.ClassSymbol)resourceType.tsym, state).map(Symbol.MethodSymbol::getThrownTypes).ifPresent(arg_0 -> ((ImmutableSet.Builder)results).addAll(arg_0));
            }
        });
        return results.build();
    }

    private static Optional<Symbol.MethodSymbol> getCloseMethod(Symbol.ClassSymbol symbol, VisitorState state) {
        Types types = state.getTypes();
        return symbol.getEnclosedElements().stream().filter(sym -> types.isAssignable(symbol.type, state.getTypeFromString(AutoCloseable.class.getName())) && sym.getSimpleName().contentEquals("close") && sym.getTypeParameters().isEmpty()).map(e -> (Symbol.MethodSymbol)e).findFirst();
    }

    static ImmutableList<Type> expandUnion(@Nullable Type type) {
        if (type == null) {
            return ImmutableList.of();
        }
        if (type.isUnion()) {
            Type.UnionClassType unionType = (Type.UnionClassType)type;
            return ImmutableList.copyOf(unionType.getAlternativeTypes());
        }
        return ImmutableList.of((Object)type);
    }

    public static Type getResultType(Tree tree) {
        return tree instanceof ExpressionTree ? ASTHelpers.getResultType((ExpressionTree)((ExpressionTree)tree)) : ASTHelpers.getType((Tree)tree);
    }

    private MoreASTHelpers() {
    }
}

