/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.AnnotationMatcherUtils;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;

@BugPattern(linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", severity=BugPattern.SeverityLevel.WARNING, summary="Using an inline Immutables @Value.Style annotation or meta-annotation with non-SOURCE retention forces consumers to add a Immutables annotations to their compile classpath.Instead use a meta-annotation with SOURCE retention.See https://github.com/immutables/immutables/issues/291.")
@AutoService(value={BugChecker.class})
public final class ImmutablesStyle
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final Matcher<ClassTree> STYLE_ANNOTATION = Matchers.hasAnnotation((String)"org.immutables.value.Value$Style");

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (STYLE_ANNOTATION.matches((Tree)tree, state)) {
            switch (tree.getKind()) {
                case CLASS: 
                case INTERFACE: {
                    return this.matchStyleAnnotatedType(tree, state);
                }
                case ANNOTATION_TYPE: {
                    return this.matchStyleMetaAnnotation(tree, state);
                }
            }
        }
        return Description.NO_MATCH;
    }

    private Description matchStyleAnnotatedType(ClassTree tree, VisitorState state) {
        if (ASTHelpers.enclosingClass((Symbol)ASTHelpers.getSymbol((ClassTree)tree)) == null) {
            return this.buildDescription(tree).addFix((Fix)SuggestedFixes.addSuppressWarnings((VisitorState)state, (String)this.canonicalName(), (String)"Automatically suppressed to unblock enforcement in new code")).build();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String qualifiedTarget = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Target.class.getName());
        String qualifiedElementType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)ElementType.class.getName());
        String qualifiedRetention = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Retention.class.getName());
        String qualifiedRetentionPolicy = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)RetentionPolicy.class.getName());
        AnnotationTree styleAnnotationTree = ImmutablesStyle.getAnnotation(tree, "org.immutables.value.Value$Style", state);
        return this.buildDescription(tree).addFix((Fix)fix.prefixWith((Tree)tree, String.format("\n@%s(%s.TYPE)\n@%s(%s.SOURCE)\n%s\n@interface %sStyle {}\n@%sStyle\n", qualifiedTarget, qualifiedElementType, qualifiedRetention, qualifiedRetentionPolicy, state.getSourceForNode((Tree)styleAnnotationTree), tree.getSimpleName(), tree.getSimpleName())).replace((Tree)styleAnnotationTree, "").build()).build();
    }

    private Description matchStyleMetaAnnotation(ClassTree tree, VisitorState state) {
        AnnotationTree retention = ImmutablesStyle.getAnnotation(tree, Retention.class.getName(), state);
        if (retention == null) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.prefixWith((Tree)tree, String.format("@%s(%s.SOURCE)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)Retention.class.getName()), SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)RetentionPolicy.class.getName())));
            return this.buildDescription(tree).addFix((Fix)fix.build()).build();
        }
        ExpressionTree retentionValue = AnnotationMatcherUtils.getArgument((AnnotationTree)retention, (String)"value");
        Symbol retentionValueSymbol = ASTHelpers.getSymbol((Tree)retentionValue);
        if (retentionValueSymbol == null || !retentionValueSymbol.getSimpleName().contentEquals("SOURCE")) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            fix.merge(SuggestedFixes.updateAnnotationArgumentValues((AnnotationTree)retention, (VisitorState)state, (String)"value", (Collection)ImmutableList.of((Object)String.format("%s.SOURCE", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)RetentionPolicy.class.getName())))));
            return this.buildDescription(tree).addFix((Fix)fix.build()).build();
        }
        return Description.NO_MATCH;
    }

    @Nullable
    private static AnnotationTree getAnnotation(ClassTree tree, String annotationType, VisitorState state) {
        List<? extends AnnotationTree> annotations = tree.getModifiers().getAnnotations();
        Type retention = state.getTypeFromString(annotationType);
        if (retention != null) {
            for (AnnotationTree annotationTree : annotations) {
                if (!ASTHelpers.isSameType((Type)ASTHelpers.getType((Tree)annotationTree.getAnnotationType()), (Type)retention, (VisitorState)state)) continue;
                return annotationTree;
            }
        }
        return null;
    }
}

