/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReferenceEquality;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;

@BugPattern(linkType=BugPattern.LinkType.CUSTOM, link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", severity=BugPattern.SeverityLevel.ERROR, summary="Comparison of Immutables value using reference equality instead of value equality.")
@AutoService(value={BugChecker.class})
public final class ImmutablesReferenceEquality
extends AbstractReferenceEquality {
    protected boolean matchArgument(ExpressionTree tree, VisitorState state) {
        Type type = ASTHelpers.getType((Tree)tree);
        if (!(type.tsym instanceof Symbol.ClassSymbol)) {
            return false;
        }
        Symbol.ClassSymbol symbol = (Symbol.ClassSymbol)type.tsym;
        return ASTHelpers.hasAnnotation((Symbol)symbol, (String)"org.immutables.value.Value.Immutable", (VisitorState)state);
    }
}

