/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.MoreMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Forbid gradle task actions (doFirst, doLast) to be implemented by lambdas.")
@AutoService(value={BugChecker.class})
public final class GradleCacheableTaskAction
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> IS_ACTION = MoreMatchers.isSubtypeOf("org.gradle.api.Action");
    private static final Matcher<ExpressionTree> TASK_ACTION = MethodMatchers.instanceMethod().onDescendantOf("org.gradle.api.Task").namedAnyOf(new String[]{"doFirst", "doLast"});
    private static final Matcher<ExpressionTree> IS_TASK_ACTION = Matchers.allOf((Matcher[])new Matcher[]{Matchers.parentNode((Matcher)Matchers.toType(ExpressionTree.class, (Matcher)Matchers.methodInvocation(TASK_ACTION))), IS_ACTION});

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (!IS_TASK_ACTION.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Gradle task actions are not cacheable when implemented by lambdas").build();
    }
}

