/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Forbid gradle argument providers to be implemented by lambdas.")
@AutoService(value={BugChecker.class})
public final class GradleCacheableArgumentProvider
extends BugChecker
implements BugChecker.LambdaExpressionTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<Tree> IS_COMMAND_LINE_ARGUMENT_PROVIDER = Matchers.isSubtypeOf((String)"org.gradle.process.CommandLineArgumentProvider");

    public Description matchLambdaExpression(LambdaExpressionTree tree, VisitorState state) {
        if (!IS_COMMAND_LINE_ARGUMENT_PROVIDER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage("Gradle command line providers are not cacheable when implemented by lambdas").build();
    }
}

