/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, summary="Implicit use of the platform default locale, which can result in differing behaviour between JVM executions.", severity=BugPattern.SeverityLevel.SUGGESTION)
@AutoService(value={BugChecker.class})
public final class DefaultLocale
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onExactClass("java.lang.String").namedAnyOf(new String[]{"toLowerCase", "toUpperCase"}).withNoParameters();

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (MATCHER.matches((Tree)tree, state)) {
            SuggestedFix.Builder fix = SuggestedFix.builder();
            return this.buildDescription(tree).addFix((Fix)fix.replace(state.getEndPosition((Tree)tree.getMethodSelect()), state.getEndPosition((Tree)tree), String.format("(%s.ROOT)", SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)"java.util.Locale"))).build()).build();
        }
        return Description.NO_MATCH;
    }
}

