/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.palantir.baseline.errorprone.TestCheckUtils;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import java.io.ObjectInput;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Disallow usage of Java's serialization features for security reasons, cf. https://cwe.mitre.org/data/definitions/502.html")
@AutoService(value={BugChecker.class})
public final class DangerousJavaDeserialization
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<MethodTree> READ_OBJECT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.methodIsNamed((String)"readObject"), Matchers.methodHasParameters((Matcher[])new Matcher[]{Matchers.isSubtypeOf((String)ObjectInput.class.getName())})});
    private static final Matcher<ExpressionTree> OBJECT_INPUT_READ_OBJECT = Matchers.allOf((Matcher[])new Matcher[]{MethodMatchers.instanceMethod().onDescendantOf(ObjectInput.class.getName()).named("readObject").withNoParameters(), Matchers.not((Matcher)Matchers.enclosingMethod(READ_OBJECT))});
    private static final Matcher<ExpressionTree> LANG3_SERIALIZATION_UTILS_DESERIALIZE = MethodMatchers.staticMethod().onClassAny(new String[]{"org.apache.commons.lang.SerializationUtils", "org.apache.commons.lang3.SerializationUtils", "org.springframework.util.SerializationUtils"}).named("deserialize");
    private static final Matcher<ExpressionTree> DESERIALIZE = Matchers.anyOf((Matcher[])new Matcher[]{OBJECT_INPUT_READ_OBJECT, LANG3_SERIALIZATION_UTILS_DESERIALIZE});

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (DESERIALIZE.matches((Tree)tree, state) && !TestCheckUtils.isTestCode(state)) {
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

