/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.MoreAbstractAsKeyOfSetOrMap;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.Name;

@BugPattern(summary="Key type does not override equals() and hashCode, so comparisons will be done on reference equality only. If neither deduplication nor lookup are needed, consider using a List instead. Otherwise, use IdentityHashMap/Set, or an Iterable/List of pairs.", severity=BugPattern.SeverityLevel.WARNING)
@AutoService(value={BugChecker.class})
public final class DangerousIdentityKey
extends MoreAbstractAsKeyOfSetOrMap {
    protected boolean isBadType(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        if (!type.isFinal()) {
            return false;
        }
        if (ASTHelpers.isSameType((Type)type, (Type)state.getSymtab().classType, (VisitorState)state)) {
            return false;
        }
        return !DangerousIdentityKey.implementsMethod(state.getTypes(), type, state.getNames().equals, state) || !DangerousIdentityKey.implementsMethod(state.getTypes(), type, state.getNames().hashCode, state);
    }

    private static boolean implementsMethod(Types types, Type type, Name methodName, VisitorState state) {
        Symbol.MethodSymbol equals = (Symbol.MethodSymbol)state.getSymtab().objectType.tsym.members().findFirst(methodName);
        return !Iterables.isEmpty((Iterable)ASTHelpers.scope((Scope)types.membersClosure(type, false)).getSymbolsByName(methodName, m -> m != equals && m.overrides(equals, type.tsym, types, false)));
    }
}

