/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Disallow usage of .collapseKeys() in EntryStream(s).")
@AutoService(value={BugChecker.class})
public final class DangerousCollapseKeysUsage
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final String ERROR_MESSAGE = "The collapseKeys API of EntryStream must be avoided. The API is frequently used as a grouping operation but its not suitable for that use case. The contract requires duplicate keys to be adjacent to each other in the stream, which is rarely the case in production code paths. When this constraint is violated, it leads to a duplicate key error at runtime.\nA work around for the issue is to sort the keys prior to running the collapse operation. Since the sort operation is surprising, a comment is often added to explain. Overall the usage of collapseKeys() leads to code that is error prone or surprising.\nHence in place of collapseKeys() we recommend using grouping operations which may require creation of intermediate maps but should avoid surprising code.";
    private static final Matcher<ExpressionTree> COLLAPSE_KEYS_CALL = MethodMatchers.instanceMethod().onExactClass("one.util.streamex.EntryStream").named("collapseKeys");

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (!COLLAPSE_KEYS_CALL.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(tree).setMessage(ERROR_MESSAGE).build();
    }
}

