/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.ImmutableParamEntry;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.immutables.value.Value;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.ERROR, summary="Method overrides should have variable names consistent with the super-method when there are multiple parameters with the same type to avoid incorrectly binding values to variables.")
@AutoService(value={BugChecker.class})
public final class ConsistentOverrides
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSymbol = ASTHelpers.getSymbol((MethodTree)tree);
        java.util.List<? extends VariableTree> methodParameters = tree.getParameters();
        if (methodSymbol == null || methodSymbol.isStatic() || methodSymbol.isPrivate() || methodParameters.size() <= 1 || !ConsistentOverrides.hasDuplicateTypes(methodParameters, state)) {
            return Description.NO_MATCH;
        }
        ConsistentOverrides.getNonParameterizedSuperMethod(methodSymbol, state.getTypes()).filter(ConsistentOverrides::retainedParameterNames).ifPresent(superMethod -> IntStream.range(0, methodParameters.size()).mapToObj(i -> ParamEntry.of(superMethod.params().get(i), i)).collect(Collectors.groupingBy(ParamEntry::type)).values().forEach(params -> {
            if (params.size() <= 1) {
                return;
            }
            for (ParamEntry expectedParam : params) {
                int index = expectedParam.index();
                VariableTree parameter = (VariableTree)methodParameters.get(index);
                String parameterName = parameter.getName().toString();
                String expectedParameterName = expectedParam.name();
                if (ConsistentOverrides.isMeaninglessParameterName(expectedParameterName) || ConsistentOverrides.equivalentNames(parameterName, expectedParameterName)) continue;
                state.reportMatch(this.buildDescription(tree).addFix((Fix)SuggestedFixes.renameVariable((VariableTree)((VariableTree)methodParameters.get(index)), (String)ConsistentOverrides.retainUnderscore(parameterName, expectedParameterName), (VisitorState)state)).build());
            }
        }));
        return Description.NO_MATCH;
    }

    private static boolean hasDuplicateTypes(java.util.List<? extends VariableTree> methodParameters, VisitorState state) {
        for (int i = 0; i < methodParameters.size() - 1; ++i) {
            Type firstType = ASTHelpers.getType((Tree)methodParameters.get(i));
            for (int j = i + 1; j < methodParameters.size(); ++j) {
                if (!state.getTypes().isSameType(firstType, ASTHelpers.getType((Tree)methodParameters.get(j)))) continue;
                return true;
            }
        }
        return false;
    }

    private static String retainUnderscore(String originalName, String newName) {
        boolean newUnderscore;
        boolean originalUnderscore = originalName.startsWith("_");
        if (originalUnderscore == (newUnderscore = newName.startsWith("_"))) {
            return newName;
        }
        if (!originalUnderscore) {
            return newName.substring(1);
        }
        return "_" + newName;
    }

    private static boolean equivalentNames(String actual, String expected) {
        return actual.equalsIgnoreCase(expected) || actual.charAt(0) == '_' && actual.length() == expected.length() + 1 && actual.substring(1).equalsIgnoreCase(expected) || expected.charAt(0) == '_' && expected.length() == actual.length() + 1 && expected.substring(1).equalsIgnoreCase(actual);
    }

    private static boolean retainedParameterNames(Symbol.MethodSymbol methodSymbol) {
        for (Symbol.VarSymbol parameter : methodSymbol.params()) {
            if (ConsistentOverrides.isUnknownParameterName(parameter.name)) continue;
            return true;
        }
        return methodSymbol.params().isEmpty();
    }

    private static boolean isMeaninglessParameterName(CharSequence input) {
        return input.length() <= 1 || ConsistentOverrides.isUnknownParameterName(input);
    }

    private static boolean isUnknownParameterName(CharSequence input) {
        int length = input.length();
        if (length > 3 && input.charAt(0) == 'a' && input.charAt(1) == 'r' && input.charAt(2) == 'g') {
            for (int i = 3; i < length; ++i) {
                char current = input.charAt(i);
                if (Character.isDigit(current)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private static Optional<Symbol.MethodSymbol> getNonParameterizedSuperMethod(Symbol.MethodSymbol methodSymbol, Types types) {
        return ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methodSymbol, (Types)types).stream().filter(superMethod -> superMethod.owner.getTypeParameters().isEmpty()).filter(superMethod -> ((List)superMethod.getTypeParameters()).isEmpty()).findFirst();
    }

    @Value.Immutable
    static interface ParamEntry {
        public Type type();

        public String name();

        public int index();

        public static ParamEntry of(Symbol.VarSymbol symbol, int index) {
            return ImmutableParamEntry.builder().type(symbol.type).name(symbol.name.toString()).index(index).build();
        }
    }
}

