/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.palantir.baseline.errorprone.ImmutableEqualsZeroExpression;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Value;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.SUGGESTION, summary="Use the isEmpty method instead of checking collection size")
@AutoService(value={BugChecker.class})
public final class CardinalityEqualsZero
extends BugChecker
implements BugChecker.BinaryTreeMatcher {
    private static final Matcher<ExpressionTree> COLLECTION_SIZE_METHOD_MATCHER = MethodMatchers.instanceMethod().onDescendantOf(Collection.class.getName()).named("size").withNoParameters();
    private static final Matcher<ExpressionTree> INT_ZERO = Matchers.intLiteral((int)0);

    public Description matchBinary(BinaryTree tree, VisitorState state) {
        Optional<EqualsZeroExpression> maybeEqualsZeroExpression = CardinalityEqualsZero.getEqualsZeroExpression(tree, state);
        if (maybeEqualsZeroExpression.isEmpty()) {
            return Description.NO_MATCH;
        }
        EqualsZeroExpression equalsZeroExpression = maybeEqualsZeroExpression.get();
        ExpressionTree operand = equalsZeroExpression.operand();
        if (!Objects.equals((Object)operand.getKind(), (Object)Tree.Kind.METHOD_INVOCATION)) {
            return Description.NO_MATCH;
        }
        ExpressionTree collectionInstance = ASTHelpers.getReceiver((ExpressionTree)operand);
        if (collectionInstance == null || CardinalityEqualsZero.isExpressionThis(collectionInstance)) {
            return Description.NO_MATCH;
        }
        if (COLLECTION_SIZE_METHOD_MATCHER.matches((Tree)operand, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((Tree)tree, (String)((equalsZeroExpression.type() == ExpressionType.NEQ ? "!" : "") + state.getSourceForNode((Tree)collectionInstance) + ".isEmpty()")));
        }
        return Description.NO_MATCH;
    }

    private static boolean isExpressionThis(ExpressionTree tree) {
        switch (tree.getKind()) {
            case IDENTIFIER: {
                return ((IdentifierTree)tree).getName().contentEquals("this");
            }
            case MEMBER_SELECT: {
                return ((MemberSelectTree)tree).getIdentifier().contentEquals("this");
            }
        }
        return false;
    }

    private static Optional<EqualsZeroExpression> getEqualsZeroExpression(BinaryTree tree, VisitorState state) {
        ExpressionType ret;
        switch (tree.getKind()) {
            case EQUAL_TO: {
                ret = ExpressionType.EQ;
                break;
            }
            case NOT_EQUAL_TO: {
                ret = ExpressionType.NEQ;
                break;
            }
            default: {
                return Optional.empty();
            }
        }
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        if (INT_ZERO.matches((Tree)leftOperand, state)) {
            return Optional.of(EqualsZeroExpression.builder().type(ret).operand(rightOperand).build());
        }
        if (INT_ZERO.matches((Tree)rightOperand, state)) {
            return Optional.of(EqualsZeroExpression.builder().type(ret).operand(leftOperand).build());
        }
        return Optional.empty();
    }

    @Value.Immutable
    static interface EqualsZeroExpression {
        public ExpressionType type();

        public ExpressionTree operand();

        public static Builder builder() {
            return new Builder();
        }

        public static class Builder
        extends ImmutableEqualsZeroExpression.Builder {
        }
    }

    static enum ExpressionType {
        EQ,
        NEQ;

    }
}

