/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.List;
import javax.lang.model.element.ElementKind;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, summary="Concrete BugChecker implementations should be annotated `@AutoService(BugChecker.class)` for auto registration with error-prone.", severity=BugPattern.SeverityLevel.ERROR, tags={"LikelyError"})
@AutoService(value={BugChecker.class})
public final class BugCheckerAutoService
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String AUTO_SERVICE = "com.google.auto.service.AutoService";
    private static final Matcher<ClassTree> isBugChecker = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isSubtypeOf(BugChecker.class), Matchers.hasAnnotation(BugPattern.class)});
    private static final Matcher<AnnotationTree> autoServiceBugChecker = Matchers.allOf((Matcher[])new Matcher[]{Matchers.isType((String)"com.google.auto.service.AutoService"), Matchers.hasArgumentWithValue((String)"value", (Matcher)Matchers.classLiteral((Matcher)Matchers.isSameType(BugChecker.class)))});

    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!isBugChecker.matches((Tree)classTree, state)) {
            return Description.NO_MATCH;
        }
        Symbol.ClassSymbol thisClassSymbol = ASTHelpers.getSymbol((ClassTree)classTree);
        if (((Symbol)thisClassSymbol).getKind() != ElementKind.CLASS) {
            return Description.NO_MATCH;
        }
        List annotations = ASTHelpers.getAnnotations((Tree)classTree);
        boolean hasAutoServiceBugChecker = annotations.stream().anyMatch(annotationTree -> autoServiceBugChecker.matches((Tree)annotationTree, state));
        if (hasAutoServiceBugChecker) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        String autoService = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)AUTO_SERVICE);
        String bugChecker = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fix, (String)BugChecker.class.getName());
        return this.buildDescription(classTree).addFix((Fix)fix.prefixWith((Tree)classTree, "@" + autoService + "(" + bugChecker + ".class)\n").build()).build();
    }
}

