/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.baseline.errorprone;

import com.google.auto.service.AutoService;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;

@BugPattern(link="https://github.com/palantir/gradle-baseline#baseline-error-prone-checks", linkType=BugPattern.LinkType.CUSTOM, severity=BugPattern.SeverityLevel.WARNING, summary="The HashMap(int) and HashSet(int) constructors are misleading: once the HashMap/HashSet reaches 3/4 of the supplied size, it resize. Instead use Maps.newHashMapWithExpectedSize or Sets.newHashSetWithExpectedSize which behaves as expected. See https://github.com/palantir/gradle-baseline/blob/develop/docs/best-practices/java-coding-guidelines/readme.md#avoid-new-HashMap(int) for more information.")
@AutoService(value={BugChecker.class})
public final class AvoidNewHashMapInt
extends BugChecker
implements BugChecker.NewClassTreeMatcher {
    private static final long serialVersionUID = 1L;
    private static final Matcher<ExpressionTree> NEW_HASH_SET = MethodMatchers.constructor().forClass("java.util.HashSet").withParameters("int", new String[0]);
    private static final Matcher<ExpressionTree> NEW_HASH_MAP = MethodMatchers.constructor().forClass("java.util.HashMap").withParameters("int", new String[0]);

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        if (NEW_HASH_SET.matches((Tree)tree, state)) {
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            String newType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)"com.google.common.collect.Sets");
            String arg = state.getSourceForNode((Tree)tree.getArguments().get(0));
            String replacement = newType + ".newHashSetWithExpectedSize(" + arg + ")";
            return this.buildDescription(tree).addFix((Fix)fixBuilder.replace((Tree)tree, replacement).build()).build();
        }
        if (NEW_HASH_MAP.matches((Tree)tree, state)) {
            SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
            String newType = SuggestedFixes.qualifyType((VisitorState)state, (SuggestedFix.Builder)fixBuilder, (String)"com.google.common.collect.Maps");
            String arg = state.getSourceForNode((Tree)tree.getArguments().get(0));
            String replacement = newType + ".newHashMapWithExpectedSize(" + arg + ")";
            return this.buildDescription(tree).addFix((Fix)fixBuilder.replace((Tree)tree, replacement).build()).build();
        }
        return Description.NO_MATCH;
    }
}

