/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.ameta;

import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class HostedDynamicHubFeature
implements Feature {
    private AnalysisMetaAccess metaAccess;
    private SVMHost hostVM;

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        this.metaAccess = access.getMetaAccess();
        this.hostVM = access.getHostVM();
        access.registerObjectReplacer(this::replace);
    }

    private Object replace(Object source) {
        if (source instanceof Class) {
            Class clazz = (Class)source;
            DynamicHub dynamicHub = this.hostVM.dynamicHub((ResolvedJavaType)this.metaAccess.lookupJavaType(clazz));
            AnalysisConstantReflectionProvider.registerHub(this.hostVM, dynamicHub);
            return dynamicHub;
        }
        if (source instanceof DynamicHub) {
            AnalysisConstantReflectionProvider.registerHub(this.hostVM, (DynamicHub)source);
        }
        return source;
    }
}

