/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.InternalPlatform;
import org.graalvm.nativeimage.impl.RuntimeClassInitializationSupport;

public class JNIRegistrationUtil {
    protected static boolean isPosix() {
        return Platform.includedIn(InternalPlatform.LINUX_JNI.class) || Platform.includedIn(InternalPlatform.DARWIN_JNI.class);
    }

    protected static boolean isWindows() {
        return Platform.includedIn(Platform.WINDOWS.class);
    }

    protected static void rerunClassInit(Feature.FeatureAccess access, String ... classNames) {
        RuntimeClassInitializationSupport classInitSupport = (RuntimeClassInitializationSupport)ImageSingletons.lookup(RuntimeClassInitializationSupport.class);
        for (String className : classNames) {
            classInitSupport.rerunInitialization(JNIRegistrationUtil.clazz(access, className), "for JDK native code support via JNI");
        }
    }

    protected static Class<?> clazz(Feature.FeatureAccess access, String className) {
        return access.findClassByName(className);
    }

    protected static Method method(Feature.FeatureAccess access, String className, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupMethod(JNIRegistrationUtil.clazz(access, className), (String)methodName, (Class[])parameterTypes);
    }

    protected static Constructor<?> constructor(Feature.FeatureAccess access, String className, Class<?> ... parameterTypes) {
        return ReflectionUtil.lookupConstructor(JNIRegistrationUtil.clazz(access, className), (Class[])parameterTypes);
    }

    protected static Field[] fields(Feature.FeatureAccess access, String className, String ... fieldNames) {
        Class<?> clazz = JNIRegistrationUtil.clazz(access, className);
        Field[] result = new Field[fieldNames.length];
        for (int i = 0; i < fieldNames.length; ++i) {
            result[i] = ReflectionUtil.lookupField(clazz, (String)fieldNames[i]);
        }
        return result;
    }
}

