/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core;

import com.oracle.svm.core.util.VMError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.impl.InternalPlatform;

public class ErrnoDirectives
implements CContext.Directives {
    public boolean isInConfiguration() {
        return Platform.includedIn(InternalPlatform.LINUX_AND_JNI.class) || Platform.includedIn(InternalPlatform.DARWIN_AND_JNI.class) || Platform.includedIn(Platform.WINDOWS.class);
    }

    public List<String> getHeaderFiles() {
        ArrayList<String> result = new ArrayList<String>();
        if (Platform.includedIn(InternalPlatform.LINUX_AND_JNI.class) || Platform.includedIn(InternalPlatform.DARWIN_AND_JNI.class)) {
            result.add("<sys/errno.h>");
        } else if (Platform.includedIn(Platform.WINDOWS.class)) {
            result.add("<errno.h>");
        } else {
            throw VMError.shouldNotReachHere("Unsupported OS");
        }
        return result;
    }

    public List<String> getMacroDefinitions() {
        if (!Platform.includedIn(Platform.WINDOWS.class)) {
            return Arrays.asList("_GNU_SOURCE", "_LARGEFILE64_SOURCE");
        }
        return Collections.emptyList();
    }
}

