/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.CodeInfoTable;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.deopt.DeoptimizedFrame;
import com.oracle.svm.core.deopt.Deoptimizer;
import com.oracle.svm.core.jdk.JDK11OrLater;
import com.oracle.svm.core.jdk.StackTraceUtils;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.core.stack.JavaStackFrameVisitor;
import com.oracle.svm.core.stack.JavaStackWalk;
import com.oracle.svm.core.stack.JavaStackWalker;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.word.WordFactory;

@TargetClass(value=StackWalker.class, onlyWith={JDK11OrLater.class})
final class Target_java_lang_StackWalker {
    @Alias
    Set<StackWalker.Option> options;
    @Alias
    boolean retainClassRef;

    Target_java_lang_StackWalker() {
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private void forEach(final Consumer<? super StackWalker.StackFrame> action) {
        final boolean showHiddenFrames = this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
        final boolean showReflectFrames = this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
        JavaStackWalker.walkCurrentThread(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress(), new JavaStackFrameVisitor(){

            @Override
            public boolean visitFrame(FrameInfoQueryResult frameInfo) {
                if (StackTraceUtils.shouldShowFrame(frameInfo, showReflectFrames, showHiddenFrames)) {
                    action.accept(new StackFrameImpl(frameInfo));
                }
                return true;
            }
        });
    }

    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private Class<?> getCallerClass() {
        if (!this.retainClassRef) {
            throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
        }
        Class<?> result = StackTraceUtils.getCallerClass(KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
        if (result == null) {
            throw new IllegalCallerException("No calling frame");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Substitute
    @NeverInline(value="Starting a stack walk in the caller frame")
    private <T> T walk(Function<? super Stream<StackWalker.StackFrame>, ? extends T> function) {
        JavaStackWalk walk = (JavaStackWalk)StackValue.get(JavaStackWalk.class);
        JavaStackWalker.initWalk(walk, KnownIntrinsics.readCallerStackPointer(), KnownIntrinsics.readReturnAddress());
        StackFrameSpliterator spliterator = new StackFrameSpliterator(walk);
        try {
            T t = function.apply(StreamSupport.stream(spliterator, false));
            return t;
        }
        finally {
            spliterator.invalidate();
        }
    }

    final class StackFrameImpl
    implements StackWalker.StackFrame {
        private final FrameInfoQueryResult frameInfo;
        private StackTraceElement ste;

        StackFrameImpl(FrameInfoQueryResult frameInfo) {
            this.frameInfo = frameInfo;
        }

        @Override
        public String getClassName() {
            return this.frameInfo.getSourceClassName();
        }

        @Override
        public String getMethodName() {
            return this.frameInfo.getSourceMethodName();
        }

        @Override
        public Class<?> getDeclaringClass() {
            if (!Target_java_lang_StackWalker.this.retainClassRef) {
                throw new UnsupportedOperationException("This stack walker does not have RETAIN_CLASS_REFERENCE access");
            }
            return this.frameInfo.getSourceClass();
        }

        @Override
        public int getByteCodeIndex() {
            return this.frameInfo.getBci();
        }

        @Override
        public String getFileName() {
            return this.frameInfo.getSourceFileName();
        }

        @Override
        public int getLineNumber() {
            return this.frameInfo.getSourceLineNumber();
        }

        @Override
        public boolean isNativeMethod() {
            return this.frameInfo.isNativeMethod();
        }

        @Override
        public StackTraceElement toStackTraceElement() {
            if (this.ste == null) {
                this.ste = this.frameInfo.getSourceReference();
            }
            return this.ste;
        }

        public String toString() {
            return this.toStackTraceElement().toString();
        }
    }

    final class StackFrameSpliterator
    implements Spliterator<StackWalker.StackFrame> {
        private final Thread thread;
        private JavaStackWalk walk;
        private DeoptimizedFrame.VirtualFrame curDeoptimizedFrame;
        private FrameInfoQueryResult curRegularFrame;

        StackFrameSpliterator(JavaStackWalk walk) {
            this.walk = walk;
            this.thread = Thread.currentThread();
        }

        void invalidate() {
            this.walk = (JavaStackWalk)WordFactory.nullPointer();
        }

        @Override
        public boolean tryAdvance(Consumer<? super StackWalker.StackFrame> action) {
            if (this.thread != Thread.currentThread()) {
                throw new IllegalStateException("Invalid thread");
            }
            if (this.walk.isNull()) {
                throw new IllegalStateException("Stack traversal no longer valid");
            }
            boolean showHiddenFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_HIDDEN_FRAMES);
            boolean showReflectFrames = Target_java_lang_StackWalker.this.options.contains((Object)StackWalker.Option.SHOW_REFLECT_FRAMES);
            while (true) {
                FrameInfoQueryResult frameInfo;
                if (this.curDeoptimizedFrame != null) {
                    frameInfo = this.curDeoptimizedFrame.getFrameInfo();
                    this.curDeoptimizedFrame = this.curDeoptimizedFrame.getCaller();
                    if (!StackTraceUtils.shouldShowFrame(frameInfo, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (this.curRegularFrame != null) {
                    frameInfo = this.curRegularFrame;
                    this.curRegularFrame = this.curRegularFrame.getCaller();
                    if (!StackTraceUtils.shouldShowFrame(frameInfo, showReflectFrames, showHiddenFrames)) continue;
                    action.accept(new StackFrameImpl(frameInfo));
                    return true;
                }
                if (!this.walk.getSP().isNonNull() || !this.walk.getIP().isNonNull()) break;
                DeoptimizedFrame deoptimizedFrame = Deoptimizer.checkDeoptimized(this.walk.getSP());
                if (deoptimizedFrame != null) {
                    this.curDeoptimizedFrame = deoptimizedFrame.getTopFrame();
                } else {
                    CodeInfoQueryResult codeInfo = CodeInfoTable.lookupCodeInfoQueryResult(this.walk.getIP());
                    this.curRegularFrame = codeInfo.getFrameInfo();
                }
                JavaStackWalker.continueWalk(this.walk);
            }
            return false;
        }

        @Override
        public Spliterator<StackWalker.StackFrame> trySplit() {
            return null;
        }

        @Override
        public long estimateSize() {
            return Long.MAX_VALUE;
        }

        @Override
        public int characteristics() {
            return 1296;
        }
    }
}

