/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalFeature;
import com.oracle.svm.graal.hosted.GraalObjectReplacer;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

public class NodeClassFeature
implements Feature {
    private GraalObjectReplacer graalObjectReplacer;
    private MetaAccessProvider metaAccess;
    private final Set<Class<?>> registeredClasses = new HashSet();

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Arrays.asList(TruffleFeature.class, GraalFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess config) {
        this.graalObjectReplacer = ((GraalFeature)ImageSingletons.lookup(GraalFeature.class)).getObjectReplacer();
        config.registerObjectReplacer(this::replaceNodeFieldAccessor);
    }

    private Object replaceNodeFieldAccessor(Object source) {
        if (source instanceof NodeFieldAccessor || source instanceof NodeFieldAccessor[] && ((NodeFieldAccessor[])source).length > 0) {
            throw VMError.shouldNotReachHere("Cannot have NodeFieldAccessor in image, they must be created lazily");
        }
        if (source instanceof NodeClass && !(source instanceof SubstrateType)) {
            NodeClass nodeClass = (NodeClass)source;
            SubstrateType replacement = this.graalObjectReplacer.createType((JavaType)this.metaAccess.lookupJavaType(nodeClass.getType()));
            assert (replacement != null);
            return replacement;
        }
        return source;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.metaAccess = access.getMetaAccess();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        for (Class<Node> clazz : access.findSubclasses(Node.class)) {
            AnalysisType type;
            try {
                type = access.getMetaAccess().lookupJavaType(clazz);
            }
            catch (UnsupportedFeatureException ex) {
                continue;
            }
            if (!type.isInstantiated()) continue;
            for (Class<Node> cur = clazz; cur != Object.class; cur = cur.getSuperclass()) {
                this.registerUnsafeAccess(access, clazz);
            }
            this.graalObjectReplacer.createType((JavaType)type);
        }
    }

    private void registerUnsafeAccess(FeatureImpl.DuringAnalysisAccessImpl access, Class<? extends Node> clazz) {
        if (this.registeredClasses.contains(clazz)) {
            return;
        }
        this.registeredClasses.add(clazz);
        NodeClass nodeClass = NodeClass.get(clazz);
        for (NodeFieldAccessor accessor : nodeClass.getFields()) {
            Field field;
            try {
                field = accessor.getDeclaringClass().getDeclaredField(accessor.getName());
            }
            catch (NoSuchFieldException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.PARENT || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                access.registerAsUnsafeAccessed(field);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.DATA) {
                access.registerAsFrozenUnsafeAccessed(field);
            }
            access.registerAsAccessed(field);
        }
        access.requireAnalysisIteration();
    }
}

