/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.phases;

import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.SVMHost;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.util.function.Supplier;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.ClassInitializationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;

public class SubstrateClassInitializationPlugin
implements ClassInitializationPlugin {
    private static final Method ENSURE_INITIALIZED_METHOD;
    private final SVMHost host;

    public SubstrateClassInitializationPlugin(SVMHost host) {
        this.host = host;
    }

    public boolean supportsLazyInitialization(ConstantPool cp) {
        return true;
    }

    public void loadReferencedType(GraphBuilderContext builder, ConstantPool constantPool, int cpi, int bytecode) {
        constantPool.loadReferencedType(cpi, bytecode);
    }

    public boolean apply(GraphBuilderContext builder, ResolvedJavaType type, Supplier<FrameState> frameState, ValueNode[] classInit) {
        if (SubstrateClassInitializationPlugin.needsRuntimeInitialization(type)) {
            JavaConstant hub = SubstrateObjectConstant.forObject(this.host.dynamicHub(type));
            ValueNode[] args = new ValueNode[]{ConstantNode.forConstant((JavaConstant)hub, (MetaAccessProvider)builder.getMetaAccess(), (StructuredGraph)builder.getGraph())};
            builder.handleReplacedInvoke(CallTargetNode.InvokeKind.Special, builder.getMetaAccess().lookupJavaMethod((Executable)ENSURE_INITIALIZED_METHOD), args, false);
            if (classInit != null) {
                classInit[0] = null;
            }
            return true;
        }
        return false;
    }

    public static boolean needsRuntimeInitialization(ResolvedJavaType type) {
        return !type.isInitialized() && !type.isArray();
    }

    static {
        try {
            ENSURE_INITIALIZED_METHOD = DynamicHub.class.getDeclaredMethod("ensureInitialized", new Class[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

