/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.analysis.Inflation;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.RuntimeReflection;

@AutomaticFeature
public class ServiceLoaderFeature
implements Feature {
    private static final String LOCATION_PREFIX = "META-INF/services/";
    private final Map<AnalysisType, Boolean> processedTypes = new ConcurrentHashMap<AnalysisType, Boolean>();
    private final boolean trace = Options.TraceServiceLoaderFeature.getValue();

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.UseServiceLoaderFeature.getValue();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        boolean workDone = false;
        for (AnalysisType type : access.getUniverse().getTypes()) {
            if (!this.handleType(type, access)) continue;
            workDone = true;
        }
        if (workDone) {
            DebugContext debugContext = access.getDebugContext();
            try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                debugContext.log("Resources have been added by ServiceLoaderFeature. Automatic registration can be disabled with " + SubstrateOptionsParser.commandArgument(Options.UseServiceLoaderFeature, "-"));
            }
        }
    }

    private boolean handleType(AnalysisType type, FeatureImpl.DuringAnalysisAccessImpl access) {
        Enumeration<URL> resourceURLs;
        if (!type.isInTypeCheck() || type.isArray()) {
            return false;
        }
        if (this.processedTypes.putIfAbsent(type, Boolean.TRUE) != null) {
            return false;
        }
        String serviceClassName = type.toClassName();
        String serviceResourceLocation = LOCATION_PREFIX + serviceClassName;
        TreeSet<String> implementationClassNames = new TreeSet<String>();
        try {
            resourceURLs = access.getImageClassLoader().getClassLoader().getResources(serviceResourceLocation);
        }
        catch (IOException ex) {
            throw UserError.abort("Error loading service implementation resources for service `" + serviceClassName + "`", ex);
        }
        while (resourceURLs.hasMoreElements()) {
            URL resourceURL = resourceURLs.nextElement();
            try {
                implementationClassNames.addAll(ServiceLoaderFeature.parseServiceResource(resourceURL));
            }
            catch (IOException ex) {
                throw UserError.abort("Error loading service implementations for service `" + serviceClassName + "` from URL `" + resourceURL + "`", ex);
            }
        }
        if (implementationClassNames.size() == 0) {
            return false;
        }
        if (this.trace) {
            System.out.println("ServiceLoaderFeature: processing service class " + serviceClassName);
        }
        StringBuilder newResourceValue = new StringBuilder(1024);
        for (String implementationClassName : implementationClassNames) {
            Class<?> implementationClass;
            if (implementationClassName.startsWith("org.graalvm.compiler") && implementationClassName.contains("hotspot")) {
                if (!this.trace) continue;
                System.out.println("  IGNORING HotSpot-specific implementation class: " + implementationClassName);
                continue;
            }
            if (this.trace) {
                System.out.println("  adding implementation class: " + implementationClassName);
            }
            if ((implementationClass = access.findClassByName(implementationClassName)) == null) {
                throw UserError.abort("Could not find registered service implementation class `" + implementationClassName + "` for service `" + serviceClassName + "`");
            }
            try {
                access.getMetaAccess().lookupJavaType(implementationClass);
            }
            catch (UnsupportedFeatureException ex) {
                if (!this.trace) continue;
                System.out.println("  cannot resolve: " + ex.getMessage());
                continue;
            }
            if (((Inflation)access.getBigBang()).getAnnotationSubstitutionProcessor().isDeleted(implementationClass)) continue;
            RuntimeReflection.register((Class[])new Class[]{implementationClass});
            RuntimeReflection.registerForReflectiveInstantiation((Class[])new Class[]{implementationClass});
            newResourceValue.append(implementationClass.getName());
            newResourceValue.append('\n');
        }
        DebugContext debugContext = access.getDebugContext();
        try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
            debugContext.log("ServiceLoaderFeature: registerResource: " + serviceResourceLocation);
        }
        Resources.registerResource(serviceResourceLocation, new ByteArrayInputStream(newResourceValue.toString().getBytes(StandardCharsets.UTF_8)));
        access.requireAnalysisIteration();
        return true;
    }

    private static Collection<String> parseServiceResource(URL resourceURL) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(resourceURL.openStream(), "utf-8"));){
            String line;
            while ((line = reader.readLine()) != null) {
                int commentIndex = line.indexOf(35);
                if (commentIndex >= 0) {
                    line = line.substring(0, commentIndex);
                }
                if ((line = line.trim()).length() == 0) continue;
                result.add(line);
            }
        }
        return result;
    }

    public static class Options {
        @Option(help={"Automatically register services for run-time lookup using ServiceLoader"}, type=OptionType.Expert)
        public static final HostedOptionKey<Boolean> UseServiceLoaderFeature = new HostedOptionKey<Boolean>(true);
        @Option(help={"When enabled, each service loader resource and class will be printed out to standard output"}, type=OptionType.Debug)
        public static final HostedOptionKey<Boolean> TraceServiceLoaderFeature = new HostedOptionKey<Boolean>(false);
    }
}

