/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.LocalizationSupport;
import com.oracle.svm.core.jdk.Resources;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.config.ResourceConfigurationParser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionType;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
public final class ResourcesFeature
implements Feature {
    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        HashSet<Object> allResources = new HashSet<Object>(Arrays.asList((Object[])Options.IncludeResources.getValue()));
        LocalizationSupport localizationSupport = (LocalizationSupport)ImageSingletons.lookup(LocalizationSupport.class);
        ResourceConfigurationParser parser = new ResourceConfigurationParser(((FeatureImpl.BeforeAnalysisAccessImpl)arg).getImageClassLoader(), allResources::add, localizationSupport::addBundleToCache);
        parser.parseAndRegisterConfigurations("resource", Options.ResourceConfigurationFiles, Options.ResourceConfigurationResources, "resource-config.json");
        for (String string : allResources) {
            if (string.length() == 0) continue;
            Pattern pattern = Pattern.compile(string);
            HashSet<File> todo = new HashSet<File>();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader instanceof URLClassLoader) {
                for (URL url : ((URLClassLoader)contextClassLoader).getURLs()) {
                    try {
                        File file = new File(url.toURI());
                        todo.add(file);
                    }
                    catch (IllegalArgumentException | URISyntaxException e) {
                        throw UserError.abort("Unable to handle imagecp element '" + url.toExternalForm() + "'. Make sure that all imagecp entries are either directories or valid jar files.");
                    }
                }
            }
            for (File element : todo) {
                try {
                    DebugContext debugContext = ((FeatureImpl.BeforeAnalysisAccessImpl)arg).getDebugContext();
                    if (element.isDirectory()) {
                        this.scanDirectory(debugContext, element, "", pattern);
                        continue;
                    }
                    ResourcesFeature.scanJar(debugContext, element, pattern);
                }
                catch (IOException ex) {
                    throw UserError.abort("Unable to handle classpath element '" + element + "'. Make sure that all classpath entries are either directories or valid jar files.");
                }
            }
        }
    }

    private void scanDirectory(DebugContext debugContext, File f, String relativePath, Pattern ... patterns) throws IOException {
        if (f.isDirectory()) {
            File[] files = f.listFiles();
            if (files == null) {
                throw UserError.abort("Cannot scan directory " + f);
            }
            for (File ch : files) {
                this.scanDirectory(debugContext, ch, relativePath.isEmpty() ? ch.getName() : relativePath + "/" + ch.getName(), patterns);
            }
        } else if (ResourcesFeature.matches(patterns, relativePath)) {
            try (FileInputStream is = new FileInputStream(f);){
                try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                    debugContext.log("ResourcesFeature: registerResource: " + relativePath);
                }
                Resources.registerResource(relativePath, is);
            }
        }
    }

    private static void scanJar(DebugContext debugContext, File element, Pattern ... patterns) throws IOException {
        JarFile jf = new JarFile(element);
        Enumeration<JarEntry> en = jf.entries();
        while (en.hasMoreElements()) {
            JarEntry e = en.nextElement();
            if (e.getName().endsWith("/") || !ResourcesFeature.matches(patterns, e.getName())) continue;
            InputStream is = jf.getInputStream(e);
            Throwable throwable = null;
            try {
                try (DebugContext.Scope s = debugContext.scope((Object)"registerResource");){
                    debugContext.log("ResourcesFeature: registerResource: " + e.getName());
                }
                Resources.registerResource(e.getName(), is);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
    }

    private static boolean matches(Pattern[] patterns, String relativePath) {
        for (Pattern p : patterns) {
            if (!p.matcher(relativePath).matches()) continue;
            return true;
        }
        return false;
    }

    public static class Options {
        @Option(help={"Regexp to match names of resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> IncludeResources = new HostedOptionKey<String[]>(new String[0]);
        @Option(help={"Files describing Java resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ResourceConfigurationFiles = new HostedOptionKey<String[]>(new String[0]);
        @Option(help={"Resources describing Java resources to be included in the image."}, type=OptionType.User)
        public static final HostedOptionKey<String[]> ResourceConfigurationResources = new HostedOptionKey<String[]>(new String[0]);
    }
}

