/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.jdk.FileTypeDetectorSupport;
import com.oracle.svm.hosted.FeatureImpl;
import java.lang.reflect.Modifier;
import java.nio.file.spi.FileTypeDetector;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.nativeimage.Feature;

@AutomaticFeature
public class ImageClasspathFileTypeDetectorFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return FileTypeDetectorSupport.Options.AddAllFileTypeDetectors.getValue();
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        DebugContext debugContext = config.getDebugContext();
        try (DebugContext.Scope s = debugContext.scope((Object)"registerFileTypeDetectors");){
            for (Class<FileTypeDetector> detector : config.findSubclasses(FileTypeDetector.class)) {
                if (detector == FileTypeDetectorSupport.AlwaysNullFileTypeDetector.class || Modifier.isAbstract(detector.getModifiers())) continue;
                try {
                    FileTypeDetectorSupport.addFirst(detector.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    debugContext.log("registerFileTypeDetectors: Registered FileTypeDetector " + detector.getName());
                }
                catch (Exception ex) {
                    debugContext.log("registerFileTypeDetectors: FileTypeDetector " + detector.getName() + " is not default constructible");
                }
            }
        }
    }
}

