/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.svm.core.config.ConfigurationValues;
import com.oracle.svm.core.graal.code.SubstrateBackend;
import com.oracle.svm.core.graal.meta.SubstrateReplacements;
import com.oracle.svm.hosted.ClassInitializationSupport;
import com.oracle.svm.hosted.SVMHost;
import com.oracle.svm.hosted.ameta.AnalysisConstantFieldProvider;
import com.oracle.svm.hosted.ameta.AnalysisConstantReflectionProvider;
import com.oracle.svm.hosted.code.SharedRuntimeConfigurationBuilder;
import com.oracle.svm.hosted.code.SubstrateGraphMakerFactory;
import java.util.function.Function;
import jdk.vm.ci.meta.ConstantReflectionProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.bytecode.BytecodeProvider;
import org.graalvm.compiler.bytecode.ResolvedJavaMethodBytecodeProvider;
import org.graalvm.compiler.core.common.spi.ConstantFieldProvider;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.util.Providers;

public class SubstrateRuntimeConfigurationBuilder
extends SharedRuntimeConfigurationBuilder {
    private final AnalysisUniverse aUniverse;
    private final ConstantReflectionProvider originalReflectionProvider;
    private final ClassInitializationSupport classInitializationSupport;

    public SubstrateRuntimeConfigurationBuilder(OptionValues options, SVMHost hostVM, AnalysisUniverse aUniverse, MetaAccessProvider metaAccess, ConstantReflectionProvider originalReflectionProvider, Function<Providers, SubstrateBackend> backendProvider, ClassInitializationSupport classInitializationSupport) {
        super(options, hostVM, metaAccess, backendProvider);
        this.aUniverse = aUniverse;
        this.originalReflectionProvider = originalReflectionProvider;
        this.classInitializationSupport = classInitializationSupport;
    }

    @Override
    protected ConstantReflectionProvider createConstantReflectionProvider(Providers p) {
        return new AnalysisConstantReflectionProvider(this.aUniverse, this.originalReflectionProvider, this.classInitializationSupport);
    }

    @Override
    protected ConstantFieldProvider createConstantFieldProvider(Providers p) {
        return new AnalysisConstantFieldProvider(this.aUniverse, p.getMetaAccess(), (AnalysisConstantReflectionProvider)p.getConstantReflection(), this.classInitializationSupport);
    }

    @Override
    protected Replacements createReplacements(Providers p, SnippetReflectionProvider snippetReflection) {
        ResolvedJavaMethodBytecodeProvider bytecodeProvider = new ResolvedJavaMethodBytecodeProvider();
        return new SubstrateReplacements(this.options, p, snippetReflection, (BytecodeProvider)bytecodeProvider, ConfigurationValues.getTarget(), new SubstrateGraphMakerFactory(this.wordTypes));
    }
}

