/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.core.StaticFieldsSupport;
import com.oracle.svm.core.graal.meta.SharedConstantReflectionProvider;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.meta.SubstrateObjectConstant;
import com.oracle.svm.core.snippets.KnownIntrinsics;
import com.oracle.svm.graal.meta.SubstrateField;
import com.oracle.svm.graal.meta.SubstrateMemoryAccessProviderImpl;
import com.oracle.svm.graal.meta.SubstrateMetaAccess;
import com.oracle.svm.graal.meta.SubstrateType;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateConstantReflectionProvider
extends SharedConstantReflectionProvider {
    private final MetaAccessProvider metaAccess;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateConstantReflectionProvider(SubstrateMetaAccess metaAccess) {
        this.metaAccess = metaAccess;
    }

    public MemoryAccessProvider getMemoryAccessProvider() {
        return SubstrateMemoryAccessProviderImpl.SINGLETON;
    }

    public ResolvedJavaType asJavaType(Constant constant) {
        Object obj;
        if (constant instanceof SubstrateObjectConstant && (obj = KnownIntrinsics.convertUnknownValue(SubstrateObjectConstant.asObject(constant), Object.class)) instanceof DynamicHub) {
            return ((SubstrateMetaAccess)this.metaAccess).lookupJavaTypeFromHub((DynamicHub)obj);
        }
        return null;
    }

    public JavaConstant asJavaClass(ResolvedJavaType type) {
        return SubstrateObjectConstant.forObject(((SubstrateType)type).getHub());
    }

    @Override
    public JavaConstant readFieldValue(ResolvedJavaField field, JavaConstant receiver) {
        return SubstrateConstantReflectionProvider.readFieldValue((SubstrateField)field, receiver);
    }

    private static JavaConstant readFieldValue(SubstrateField field, JavaConstant receiver) {
        JavaConstant base;
        if (field.constantValue != null) {
            return field.constantValue;
        }
        if (field.location < 0) {
            return null;
        }
        if (receiver == null) {
            assert (field.isStatic());
            base = field.type.getStorageKind() == JavaKind.Object ? SubstrateObjectConstant.forObject(StaticFieldsSupport.getStaticObjectFields()) : SubstrateObjectConstant.forObject(StaticFieldsSupport.getStaticPrimitiveFields());
        } else {
            assert (!field.isStatic());
            base = receiver;
        }
        assert (SubstrateObjectConstant.asObject((Constant)base) != null);
        try {
            return SubstrateMemoryAccessProviderImpl.readUnsafeConstant(field.type.getStorageKind(), base, field.location, field.isVolatile());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

