/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.VMThreads;
import com.oracle.svm.core.windows.WindowsVMCondition;
import com.oracle.svm.core.windows.WindowsVMMutex;
import com.oracle.svm.core.windows.headers.Process;
import com.oracle.svm.core.windows.headers.WinBase;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.LogHandler;

public final class WindowsVMLockSupport {
    @UnknownObjectField(types={WindowsVMMutex[].class})
    protected WindowsVMMutex[] mutexes;
    @UnknownObjectField(types={WindowsVMCondition[].class})
    protected WindowsVMCondition[] conditions;
    @UnknownObjectField(types={byte[].class})
    protected byte[] syncStructs;

    @Uninterruptible(reason="Called from uninterruptible code. Too early for safepoints.")
    public static void initialize() {
        for (WindowsVMMutex mutex : ((WindowsVMLockSupport)ImageSingletons.lookup(WindowsVMLockSupport.class)).mutexes) {
            Process.InitializeCriticalSection(mutex.getStructPointer());
        }
        for (WindowsVMCondition condition : ((WindowsVMLockSupport)ImageSingletons.lookup(WindowsVMLockSupport.class)).conditions) {
            Process.InitializeConditionVariable(condition.getStructPointer());
        }
    }

    @Uninterruptible(reason="Called from uninterruptible code.", calleeMustBe=false)
    protected static void checkResult(int result, String functionName) {
        if (result == 0) {
            VMThreads.StatusSupport.setStatusIgnoreSafepoints();
            int lastError = WinBase.GetLastError();
            Log.log().string(functionName).string(" returned ").signed(result).string(" GetLastError returned: 0x").hex(lastError).newline();
            ((LogHandler)ImageSingletons.lookup(LogHandler.class)).fatalError();
        }
    }
}

