/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.jni.JNIRuntimeAccess;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.RuntimeClassInitialization;
import org.graalvm.nativeimage.c.function.CLibrary;

@Platforms(value={Platform.WINDOWS.class})
@AutomaticFeature
@CLibrary(value="java")
class WindowsJavaIOSubstituteFeature
implements Feature {
    WindowsJavaIOSubstituteFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.io.RandomAccessFile")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.ZipFile")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.Inflater")});
        RuntimeClassInitialization.rerunClassInitialization((Class[])new Class[]{access.findClassByName("java.util.zip.Deflater")});
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        try {
            JNIRuntimeAccess.register(String.class);
            JNIRuntimeAccess.register(File.class);
            JNIRuntimeAccess.register(File.class.getDeclaredField("path"));
            JNIRuntimeAccess.register(FileOutputStream.class);
            JNIRuntimeAccess.register(FileOutputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileInputStream.class);
            JNIRuntimeAccess.register(FileInputStream.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class);
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(FileDescriptor.class.getDeclaredField("handle"));
            JNIRuntimeAccess.register(RandomAccessFile.class);
            JNIRuntimeAccess.register(RandomAccessFile.class.getDeclaredField("fd"));
            JNIRuntimeAccess.register(access.findClassByName("java.io.WinNTFileSystem"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("needDict"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Inflater.class.getDeclaredField("len"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("level"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("strategy"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("setParams"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finish"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("finished"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("buf"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("off"));
            JNIRuntimeAccess.register(Deflater.class.getDeclaredField("len"));
        }
        catch (NoSuchFieldException e) {
            VMError.shouldNotReachHere("WindowsJavaIOSubstitutionFeature: Error registering class or method: ", e);
        }
    }
}

