/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.UnsafeAccess;
import com.oracle.svm.core.util.VMError;
import java.util.Objects;
import java.util.function.Supplier;

public final class LazyFinalReference<T> {
    private static final long VALUE_OFFSET;
    private final Supplier<T> supplier;
    private T value;

    public LazyFinalReference(Supplier<T> supplier) {
        this.supplier = supplier;
    }

    public T get() {
        Object v = this.value;
        if (v == null && (v = UnsafeAccess.UNSAFE.getObjectVolatile(this, VALUE_OFFSET)) == null) {
            T obj = Objects.requireNonNull(this.supplier.get());
            v = UnsafeAccess.UNSAFE.compareAndSwapObject(this, VALUE_OFFSET, null, v) ? obj : UnsafeAccess.UNSAFE.getObjectVolatile(this, VALUE_OFFSET);
            assert (v != null);
        }
        return v;
    }

    static {
        try {
            VALUE_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(LazyFinalReference.class.getDeclaredField("value"));
        }
        catch (Throwable ex) {
            throw VMError.shouldNotReachHere(ex);
        }
    }
}

