/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.util;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.util.Counter;
import com.oracle.svm.core.util.CounterGroupList;
import com.oracle.svm.core.util.CounterSupport;
import java.util.ArrayList;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;

@AutomaticFeature
public class CounterFeature
implements Feature {
    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        ImageSingletons.add(CounterGroupList.class, (Object)new CounterGroupList());
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        CounterGroupList counterGroupList = (CounterGroupList)ImageSingletons.lookup(CounterGroupList.class);
        ArrayList<Counter.Group> enabledGroups = new ArrayList<Counter.Group>(counterGroupList.value.size());
        for (Counter.Group group2 : counterGroupList.value) {
            group2.enabled = group2.enabledOption.getValue();
            if (!group2.enabled) continue;
            enabledGroups.add(group2);
        }
        enabledGroups.sort((g1, g2) -> g1.name.compareTo(g2.name));
        ImageSingletons.add(CounterSupport.class, (Object)new CounterSupport(enabledGroups.toArray(new Counter.Group[enabledGroups.size()])));
    }
}

