/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.thread.JavaThreads;
import com.oracle.svm.core.thread.VMOperation;
import com.oracle.svm.core.thread.VMThreads;
import java.util.List;
import org.graalvm.nativeimage.CurrentIsolate;
import org.graalvm.nativeimage.IsolateThread;
import org.graalvm.word.WordBase;

class ThreadListOperation
extends VMOperation {
    private final List<Thread> list;

    ThreadListOperation(List<Thread> list) {
        super("ReqeustTearDownOperation", VMOperation.CallerEffect.BLOCKS_CALLER, VMOperation.SystemEffect.CAUSES_SAFEPOINT);
        this.list = list;
    }

    @Override
    public void operate() {
        Log trace = Log.noopLog().string("[ThreadListOperation.operate:").string("  queuingVMThread: ").hex((WordBase)this.getQueuingVMThread()).string("  currentVMThread: ").hex((WordBase)CurrentIsolate.getCurrentThread()).flush();
        this.list.clear();
        IsolateThread isolateThread = VMThreads.firstThread();
        while (VMThreads.isNonNullThread(isolateThread)) {
            Thread thread = JavaThreads.singleton().fromVMThread(isolateThread);
            if (thread != null) {
                this.list.add(thread);
            }
            isolateThread = VMThreads.nextThread(isolateThread);
        }
        trace.string("]").newline().flush();
    }
}

