/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.annotate.RestrictHeapAccess;
import com.oracle.svm.core.heap.Heap;
import com.oracle.svm.core.heap.PhysicalMemory;
import com.oracle.svm.core.posix.headers.Unistd;
import com.oracle.svm.core.util.UnsignedUtils;
import java.io.FileInputStream;
import java.io.IOException;
import org.graalvm.nativeimage.Feature;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;
import org.graalvm.word.WordFactory;

@Platforms(value={Platform.LINUX_AND_JNI.class})
class LinuxPhysicalMemory
extends PhysicalMemory {
    LinuxPhysicalMemory() {
    }

    @AutomaticFeature
    static class PhysicalMemoryFeature
    implements Feature {
        PhysicalMemoryFeature() {
        }

        public void afterRegistration(Feature.AfterRegistrationAccess access) {
            ImageSingletons.add(PhysicalMemory.PhysicalMemorySupport.class, (Object)new PhysicalMemorySupportImpl());
        }
    }

    static class PhysicalMemorySupportImpl
    implements PhysicalMemory.PhysicalMemorySupport {
        static final long UNSET_SENTINEL = Long.MIN_VALUE;
        long cachedSize = Long.MIN_VALUE;
        private static final String cgroupMemoryFileName = "/sys/fs/cgroup/memory/memory.limit_in_bytes";

        PhysicalMemorySupportImpl() {
        }

        @Override
        public UnsignedWord size() {
            if (this.hasSize()) {
                return this.getSize();
            }
            if (Heap.getHeap().isAllocationDisallowed()) {
                return UnsignedUtils.MAX_VALUE;
            }
            this.initializeSize();
            return this.getSize();
        }

        @Override
        public boolean hasSize() {
            return this.cachedSize != Long.MIN_VALUE;
        }

        void setSize(long value) {
            this.cachedSize = value;
        }

        UnsignedWord getSize() {
            assert (this.hasSize()) : "LinuxPhysicalMemory.PhysicalMemorySupportImpl.geSize: cachedSize has no value.";
            return WordFactory.unsigned((long)this.cachedSize);
        }

        void initializeSize() {
            long cgroupSize = this.sizeFromCGroup();
            long sysconfSize = this.sizeFromSysconf();
            long minSize = Math.min(cgroupSize, sysconfSize);
            this.setSize(minSize);
        }

        long sizeFromSysconf() {
            long numberOfPhysicalMemoryPages = Unistd.sysconf(Unistd._SC_PHYS_PAGES());
            long sizeOfAPhysicalMemoryPage = Unistd.sysconf(Unistd._SC_PAGESIZE());
            long result = numberOfPhysicalMemoryPages * sizeOfAPhysicalMemoryPage;
            return result;
        }

        @RestrictHeapAccess(access=RestrictHeapAccess.Access.UNRESTRICTED, overridesCallers=true, reason="Only called if allocation is allowed.")
        long sizeFromCGroup() {
            assert (!Heap.getHeap().isAllocationDisallowed()) : "LinuxPhysicalMemory.PhysicalMemorySupportImpl.sizeFromCGroup: Allocation disallowed.";
            long result = Long.MAX_VALUE;
            try {
                int index;
                FileInputStream stream = new FileInputStream(cgroupMemoryFileName);
                int maxIndex = 31;
                char[] charBuffer = new char[32];
                int read = stream.read();
                for (index = 0; index < 31 && read >= 48 && read <= 57; ++index) {
                    charBuffer[index] = (char)read;
                    read = stream.read();
                }
                String stringBuffer = new String(charBuffer, 0, index);
                result = Long.parseLong(stringBuffer);
            }
            catch (IOException | NumberFormatException exception) {
                // empty catch block
            }
            return result;
        }
    }
}

