/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.darwin;

import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import com.oracle.svm.core.posix.headers.Dirent;
import com.oracle.svm.core.posix.headers.Stat;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.function.CFunctionPointer;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.word.PointerBase;
import org.graalvm.word.SignedWord;

@Platforms(value={Platform.DARWIN.class})
class DarwinInode64Suffix {
    DarwinInode64Suffix() {
    }

    @TargetClass(value=Stat.class)
    static final class Target_com_oracle_svm_core_posix_headers_Stat {
        Target_com_oracle_svm_core_posix_headers_Stat() {
        }

        @Substitute
        @CFunction(value="stat$INODE64")
        private static native int stat(CCharPointer var0, Stat.stat var1);

        @Substitute
        @CFunction(value="fstat$INODE64")
        private static native int fstat(int var0, Stat.stat var1);

        @Substitute
        @CFunction(value="lstat$INODE64")
        private static native int lstat(CCharPointer var0, Stat.stat var1);
    }

    @TargetClass(value=Dirent.class)
    static final class Target_com_oracle_svm_core_posix_headers_Dirent {
        Target_com_oracle_svm_core_posix_headers_Dirent() {
        }

        @Substitute
        @CFunction(value="opendir$INODE64")
        private static native Dirent.DIR opendir(CCharPointer var0);

        @Substitute
        @CFunction(value="readdir$INODE64")
        private static native Dirent.dirent readdir(Dirent.DIR var0);

        @Substitute
        @CFunction(value="readdir_r$INODE64")
        private static native int readdir_r(Dirent.DIR var0, Dirent.dirent var1, Dirent.direntPointer var2);

        @Substitute
        @CFunction(value="rewinddir$INODE64")
        private static native void rewinddir(Dirent.DIR var0);

        @Substitute
        @CFunction(value="seekdir$INODE64")
        private static native void seekdir(Dirent.DIR var0, long var1);

        @Substitute
        @CFunction(value="telldir$INODE64")
        private static native long telldir(Dirent.DIR var0);

        @Substitute
        @CFunction(value="scandir$INODE64")
        private static native int scandir(CCharPointer var0, PointerBase var1, CFunctionPointer var2, CFunctionPointer var3);

        @Substitute
        @CFunction(value="alphasort$INODE64")
        private static native int alphasort(Dirent.direntPointer var0, Dirent.direntPointer var1);

        @Substitute
        @CFunction(value="_getdirentries_is_not_available_when_64_bit_inodes_are_in_effect")
        private static native SignedWord getdirentries(int var0, CCharPointer var1, SignedWord var2, PointerBase var3);
    }
}

